/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.virtualhostnode.derby;

import java.util.Map;
import org.apache.qpid.server.logging.LogSubject;
import org.apache.qpid.server.logging.messages.ConfigStoreMessages;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.ManagedAttributeField;
import org.apache.qpid.server.model.ManagedObject;
import org.apache.qpid.server.model.ManagedObjectFactoryConstructor;
import org.apache.qpid.server.model.VirtualHost;
import org.apache.qpid.server.store.DurableConfigurationStore;
import org.apache.qpid.server.store.derby.DerbyConfigurationStore;
import org.apache.qpid.server.virtualhostnode.AbstractStandardVirtualHostNode;
import org.apache.qpid.server.virtualhostnode.derby.DerbyVirtualHostNode;

@ManagedObject(category=false, type="DERBY")
public class DerbyVirtualHostNodeImpl
extends AbstractStandardVirtualHostNode<DerbyVirtualHostNodeImpl>
implements DerbyVirtualHostNode<DerbyVirtualHostNodeImpl> {
    public static final String VIRTUAL_HOST_NODE_TYPE = "DERBY";
    @ManagedAttributeField
    private String _storePath;

    @ManagedObjectFactoryConstructor
    public DerbyVirtualHostNodeImpl(Map<String, Object> attributes, Broker<?> parent) {
        super(attributes, parent);
    }

    protected void writeLocationEventLog() {
        this.getEventLogger().message((LogSubject)this.getConfigurationStoreLogSubject(), ConfigStoreMessages.STORE_LOCATION((String)this.getStorePath()));
    }

    protected DurableConfigurationStore createConfigurationStore() {
        return new DerbyConfigurationStore(VirtualHost.class);
    }

    @Override
    public String getStorePath() {
        return this._storePath;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [id=" + this.getId() + ", name=" + this.getName() + ", storePath=" + this.getStorePath() + "]";
    }
}

