/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.jmx;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.rmi.AlreadyBoundException;
import java.rmi.NoSuchObjectException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXServiceURL;
import javax.management.remote.MBeanServerForwarder;
import javax.management.remote.rmi.RMIConnectorServer;
import javax.net.ssl.SSLContext;
import javax.rmi.ssl.SslRMIClientSocketFactory;
import org.apache.log4j.Logger;
import org.apache.qpid.server.jmx.CustomRMIServerSocketFactory;
import org.apache.qpid.server.jmx.JMXManagement;
import org.apache.qpid.server.jmx.MBeanInvocationHandlerImpl;
import org.apache.qpid.server.jmx.ManagedObject;
import org.apache.qpid.server.jmx.ManagedObjectRegistry;
import org.apache.qpid.server.jmx.ManagementLogonLogoffReporter;
import org.apache.qpid.server.jmx.QpidSslRMIServerSocketFactory;
import org.apache.qpid.server.jmx.UsernameCachingRMIJRMPServer;
import org.apache.qpid.server.logging.EventLogger;
import org.apache.qpid.server.logging.EventLoggerProvider;
import org.apache.qpid.server.logging.messages.ManagementConsoleMessages;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.KeyStore;
import org.apache.qpid.server.model.Port;
import org.apache.qpid.server.model.Transport;
import org.apache.qpid.server.security.auth.jmx.JMXPasswordAuthenticator;
import org.apache.qpid.server.util.ServerScopedRuntimeException;

public class JMXManagedObjectRegistry
implements ManagedObjectRegistry {
    private static final Logger _log = Logger.getLogger(JMXManagedObjectRegistry.class);
    private static final String OPERATIONAL_LOGGING_NAME = "JMX";
    private final MBeanServer _mbeanServer;
    private JMXConnectorServer _cs;
    private Registry _rmiRegistry;
    private final Broker _broker;
    private final Port _registryPort;
    private final Port _connectorPort;

    public JMXManagedObjectRegistry(Broker broker, Port connectorPort, Port registryPort, JMXManagement jmxManagement) {
        this._broker = broker;
        this._registryPort = registryPort;
        this._connectorPort = connectorPort;
        boolean usePlatformServer = (Boolean)jmxManagement.getAttribute("usePlatformMBeanServer");
        this._mbeanServer = usePlatformServer ? ManagementFactory.getPlatformMBeanServer() : MBeanServerFactory.createMBeanServer("org.apache.qpid");
    }

    private EventLogger getEventLogger() {
        return this._broker.getEventLogger();
    }

    @Override
    public void start() throws IOException {
        this.getEventLogger().message(ManagementConsoleMessages.STARTUP((String)OPERATIONAL_LOGGING_NAME));
        if (this.areOutOfTheBoxJMXOptionsSet()) {
            this.getEventLogger().message(ManagementConsoleMessages.READY((String)OPERATIONAL_LOGGING_NAME));
        } else {
            this.startRegistryAndConnector();
        }
    }

    private void startRegistryAndConnector() throws IOException {
        QpidSslRMIServerSocketFactory ssf;
        SslRMIClientSocketFactory csf;
        boolean connectorSslEnabled = this._connectorPort.getTransports().contains(Transport.SSL);
        if (connectorSslEnabled) {
            SSLContext sslContext;
            KeyStore keyStore = this._connectorPort.getKeyStore();
            try {
                sslContext = SSLContext.getInstance("TLS");
                sslContext.init(keyStore.getKeyManagers(), null, null);
            }
            catch (GeneralSecurityException e) {
                throw new ServerScopedRuntimeException("Unable to create SSLContext for key store", (Throwable)e);
            }
            this.getEventLogger().message(ManagementConsoleMessages.SSL_KEYSTORE((String)keyStore.getName()));
            csf = new SslRMIClientSocketFactory();
            ssf = new QpidSslRMIServerSocketFactory(sslContext);
        } else {
            csf = null;
            ssf = null;
        }
        int jmxPortRegistryServer = this._registryPort.getPort();
        int jmxPortConnectorServer = this._connectorPort.getPort();
        JMXPasswordAuthenticator rmipa = new JMXPasswordAuthenticator(this._broker, (SocketAddress)new InetSocketAddress(jmxPortConnectorServer));
        HashMap<String, JMXPasswordAuthenticator> connectorEnv = new HashMap<String, JMXPasswordAuthenticator>();
        connectorEnv.put("jmx.remote.authenticator", rmipa);
        System.setProperty("java.rmi.server.randomIDs", "true");
        boolean useCustomSocketFactory = Boolean.parseBoolean(System.getProperty("qpid.broker_jmx_use_custom_rmi_socket_factory", Boolean.TRUE.toString()));
        this._rmiRegistry = this.createRmiRegistry(jmxPortRegistryServer, useCustomSocketFactory);
        final UsernameCachingRMIJRMPServer usernameCachingRmiServer = new UsernameCachingRMIJRMPServer(jmxPortConnectorServer, csf, ssf, connectorEnv);
        String localHostName = this.getLocalhost();
        final JMXServiceURL externalUrl = new JMXServiceURL("service:jmx:rmi://" + localHostName + ":" + jmxPortConnectorServer + "/jndi/rmi://" + localHostName + ":" + jmxPortRegistryServer + "/jmxrmi");
        JMXServiceURL internalUrl = new JMXServiceURL("rmi", localHostName, jmxPortConnectorServer);
        this._cs = new RMIConnectorServer(internalUrl, connectorEnv, usernameCachingRmiServer, this._mbeanServer){

            @Override
            public synchronized void start() throws IOException {
                try {
                    JMXManagedObjectRegistry.this._rmiRegistry.bind("jmxrmi", usernameCachingRmiServer);
                }
                catch (AlreadyBoundException abe) {
                    IOException ioe = new IOException(abe.getMessage());
                    ioe.initCause(abe);
                    throw ioe;
                }
                super.start();
            }

            @Override
            public synchronized void stop() throws IOException {
                try {
                    if (JMXManagedObjectRegistry.this._rmiRegistry != null) {
                        JMXManagedObjectRegistry.this._rmiRegistry.unbind("jmxrmi");
                    }
                }
                catch (NotBoundException nbe) {
                    _log.error((Object)"Failed to unbind jmxrmi", (Throwable)nbe);
                }
                super.stop();
            }

            @Override
            public JMXServiceURL getAddress() {
                return externalUrl;
            }
        };
        MBeanServerForwarder mbsf = MBeanInvocationHandlerImpl.newProxyInstance(this._broker);
        this._cs.setMBeanServerForwarder(mbsf);
        ManagementLogonLogoffReporter jmxManagementUserLogonLogoffReporter = new ManagementLogonLogoffReporter((EventLoggerProvider)this._broker, usernameCachingRmiServer);
        this._cs.addNotificationListener(jmxManagementUserLogonLogoffReporter, jmxManagementUserLogonLogoffReporter, null);
        this._cs.addNotificationListener(usernameCachingRmiServer, usernameCachingRmiServer, null);
        this._cs.start();
        String connectorServer = (connectorSslEnabled ? "SSL " : "") + "JMX RMIConnectorServer";
        this.getEventLogger().message(ManagementConsoleMessages.LISTENING((String)connectorServer, (Number)jmxPortConnectorServer));
        this.getEventLogger().message(ManagementConsoleMessages.READY((String)OPERATIONAL_LOGGING_NAME));
    }

    private Registry createRmiRegistry(int jmxPortRegistryServer, boolean useCustomRmiRegistry) throws RemoteException {
        Registry rmiRegistry;
        if (useCustomRmiRegistry) {
            _log.debug((Object)"Using custom RMIServerSocketFactory");
            rmiRegistry = LocateRegistry.createRegistry(jmxPortRegistryServer, null, new CustomRMIServerSocketFactory());
        } else {
            _log.debug((Object)"Using default RMIServerSocketFactory");
            rmiRegistry = LocateRegistry.createRegistry(jmxPortRegistryServer, null, null);
        }
        this.getEventLogger().message(ManagementConsoleMessages.LISTENING((String)"RMI Registry", (Number)jmxPortRegistryServer));
        return rmiRegistry;
    }

    @Override
    public void registerObject(ManagedObject managedObject) throws JMException {
        this._mbeanServer.registerMBean(managedObject, managedObject.getObjectName());
    }

    @Override
    public void unregisterObject(ManagedObject managedObject) throws JMException {
        this._mbeanServer.unregisterMBean(managedObject.getObjectName());
    }

    public void close() {
        _log.debug((Object)"close() called");
        this.closeConnectorAndRegistryServers();
        this.unregisterAllMbeans();
        this.getEventLogger().message(ManagementConsoleMessages.STOPPED((String)OPERATIONAL_LOGGING_NAME));
    }

    private void closeConnectorAndRegistryServers() {
        this.closeConnectorServer();
        this.closeRegistryServer();
    }

    private boolean areOutOfTheBoxJMXOptionsSet() {
        if (System.getProperty("com.sun.management.jmxremote") != null) {
            return true;
        }
        return System.getProperty("com.sun.management.jmxremote.port") != null;
    }

    private String getLocalhost() {
        String localHost;
        try {
            localHost = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException ex) {
            localHost = "127.0.0.1";
        }
        return localHost;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeRegistryServer() {
        if (this._rmiRegistry != null) {
            this.getEventLogger().message(ManagementConsoleMessages.SHUTTING_DOWN((String)"RMI Registry", (Number)this._registryPort.getPort()));
            try {
                boolean success = UnicastRemoteObject.unexportObject(this._rmiRegistry, false);
                if (!success) {
                    _log.warn((Object)("Failed to unexport object " + this._rmiRegistry));
                }
            }
            catch (NoSuchObjectException e) {
                _log.error((Object)"Exception while closing the RMI Registry: ", (Throwable)e);
            }
            finally {
                this._rmiRegistry = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeConnectorServer() {
        if (this._cs != null) {
            try {
                this.getEventLogger().message(ManagementConsoleMessages.SHUTTING_DOWN((String)"JMX RMIConnectorServer", (Number)this._cs.getAddress().getPort()));
                this._cs.stop();
            }
            catch (IOException e) {
                _log.error((Object)"Exception while closing the JMX ConnectorServer: ", (Throwable)e);
            }
            finally {
                this._cs = null;
            }
        }
    }

    private void unregisterAllMbeans() {
        ObjectName mbeanNameQuery = null;
        try {
            mbeanNameQuery = new ObjectName("org.apache.qpid:*");
        }
        catch (Exception e1) {
            _log.warn((Object)"Unable to generate MBean ObjectName query for close operation");
        }
        for (ObjectName name : this._mbeanServer.queryNames(mbeanNameQuery, null)) {
            try {
                this._mbeanServer.unregisterMBean(name);
            }
            catch (JMException e) {
                _log.error((Object)("Exception unregistering MBean '" + name + "': " + e.getMessage()));
            }
        }
    }
}

