/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.jmx;

import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.management.JMException;
import org.apache.log4j.Logger;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.jmx.AMQManagedObject;
import org.apache.qpid.server.jmx.JMXManagedObjectRegistry;
import org.apache.qpid.server.jmx.MBeanProvider;
import org.apache.qpid.server.jmx.mbeans.LoggingManagementMBean;
import org.apache.qpid.server.jmx.mbeans.ServerInformationMBean;
import org.apache.qpid.server.jmx.mbeans.Shutdown;
import org.apache.qpid.server.jmx.mbeans.UserManagementMBean;
import org.apache.qpid.server.jmx.mbeans.VirtualHostMBean;
import org.apache.qpid.server.logging.log4j.LoggingManagementFacade;
import org.apache.qpid.server.model.AuthenticationProvider;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.ConfigurationChangeListener;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.ManagedAttribute;
import org.apache.qpid.server.model.PasswordCredentialManagingAuthenticationProvider;
import org.apache.qpid.server.model.Port;
import org.apache.qpid.server.model.Protocol;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.VirtualHost;
import org.apache.qpid.server.model.adapter.AbstractPluginAdapter;
import org.apache.qpid.server.plugin.QpidServiceLoader;
import org.apache.qpid.server.util.MapValueConverter;
import org.apache.qpid.server.util.ServerScopedRuntimeException;

public class JMXManagement
extends AbstractPluginAdapter<JMXManagement>
implements ConfigurationChangeListener {
    private static final Logger LOGGER = Logger.getLogger(JMXManagement.class);
    public static final String PLUGIN_TYPE = "MANAGEMENT-JMX";
    public static final String USE_PLATFORM_MBEAN_SERVER = "usePlatformMBeanServer";
    public static final String NAME = "name";
    public static final String DEFAULT_NAME = "JMXManagement";
    public static final boolean DEFAULT_USE_PLATFORM_MBEAN_SERVER = true;
    private static final Map<String, Object> DEFAULTS = new HashMap<String, Object>(){
        {
            this.put(JMXManagement.USE_PLATFORM_MBEAN_SERVER, true);
            this.put(JMXManagement.NAME, JMXManagement.DEFAULT_NAME);
            this.put("pluginType", JMXManagement.PLUGIN_TYPE);
        }
    };
    private static final Map<String, Type> ATTRIBUTE_TYPES = new HashMap<String, Type>(){
        {
            this.put(JMXManagement.USE_PLATFORM_MBEAN_SERVER, Boolean.class);
            this.put(JMXManagement.NAME, String.class);
            this.put("pluginType", String.class);
        }
    };
    private JMXManagedObjectRegistry _objectRegistry;
    private final Map<ConfiguredObject, AMQManagedObject> _children = new HashMap<ConfiguredObject, AMQManagedObject>();

    public JMXManagement(UUID id, Broker broker, Map<String, Object> attributes) {
        super(id, DEFAULTS, MapValueConverter.convert(attributes, ATTRIBUTE_TYPES), broker);
    }

    protected boolean setState(State currentState, State desiredState) {
        if (desiredState == State.ACTIVE) {
            try {
                this.start();
            }
            catch (Exception e) {
                throw new ServerScopedRuntimeException("Couldn't start JMX management", (Throwable)e);
            }
            return true;
        }
        if (desiredState == State.STOPPED) {
            this.stop();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void start() throws JMException, IOException {
        Broker broker = this.getBroker();
        Port connectorPort = null;
        Port registryPort = null;
        Collection ports = broker.getPorts();
        for (Port port : ports) {
            if (State.QUIESCED.equals((Object)port.getState())) continue;
            if (this.isRegistryPort(port)) {
                registryPort = port;
                continue;
            }
            if (!this.isConnectorPort(port)) continue;
            connectorPort = port;
        }
        if (connectorPort == null) {
            throw new IllegalStateException("No JMX connector port found supporting protocol " + Protocol.JMX_RMI);
        }
        if (registryPort == null) {
            throw new IllegalStateException("No JMX RMI port found supporting protocol " + Protocol.RMI);
        }
        this._objectRegistry = new JMXManagedObjectRegistry(broker, connectorPort, registryPort, this);
        broker.addChangeListener((ConfigurationChangeListener)this);
        Map<ConfiguredObject, AMQManagedObject> map = this._children;
        synchronized (map) {
            for (VirtualHost virtualHost : broker.getVirtualHosts()) {
                if (this._children.containsKey(virtualHost)) continue;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Create MBean for virtual host:" + virtualHost.getName()));
                }
                VirtualHostMBean mbean = new VirtualHostMBean(virtualHost, this._objectRegistry);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Check for additional MBeans for virtual host:" + virtualHost.getName()));
                }
                this.createAdditionalMBeansFromProviders((ConfiguredObject)virtualHost, mbean);
            }
            Collection authenticationProviders = broker.getAuthenticationProviders();
            for (AuthenticationProvider authenticationProvider : authenticationProviders) {
                if (!(authenticationProvider instanceof PasswordCredentialManagingAuthenticationProvider)) continue;
                UserManagementMBean mbean = new UserManagementMBean((PasswordCredentialManagingAuthenticationProvider)authenticationProvider, this._objectRegistry);
                this._children.put((ConfiguredObject)authenticationProvider, mbean);
            }
        }
        new Shutdown(this._objectRegistry);
        new ServerInformationMBean(this._objectRegistry, broker);
        if (LoggingManagementFacade.getCurrentInstance() != null) {
            new LoggingManagementMBean(LoggingManagementFacade.getCurrentInstance(), this._objectRegistry);
        }
        this._objectRegistry.start();
    }

    private boolean isConnectorPort(Port port) {
        return port.getProtocols().contains(Protocol.JMX_RMI);
    }

    private boolean isRegistryPort(Port port) {
        return port.getProtocols().contains(Protocol.RMI);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stop() {
        Map<ConfiguredObject, AMQManagedObject> map = this._children;
        synchronized (map) {
            for (ConfiguredObject object : this._children.keySet()) {
                AMQManagedObject mbean = this._children.get(object);
                if (mbean instanceof ConfigurationChangeListener) {
                    object.removeChangeListener((ConfigurationChangeListener)mbean);
                }
                try {
                    mbean.unregister();
                }
                catch (Exception e) {
                    LOGGER.error((Object)("Exception while unregistering mbean for " + object.getClass().getSimpleName() + " " + object.getName()), (Throwable)e);
                }
            }
            this._children.clear();
        }
        this.getBroker().removeChangeListener((ConfigurationChangeListener)this);
        this.closeObjectRegistry();
    }

    public void stateChanged(ConfiguredObject object, State oldState, State newState) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void childAdded(ConfiguredObject object, ConfiguredObject child) {
        Map<ConfiguredObject, AMQManagedObject> map = this._children;
        synchronized (map) {
            try {
                AMQManagedObject mbean;
                if (child instanceof VirtualHost) {
                    VirtualHost vhostChild = (VirtualHost)child;
                    mbean = new VirtualHostMBean(vhostChild, this._objectRegistry);
                } else {
                    mbean = child instanceof PasswordCredentialManagingAuthenticationProvider ? new UserManagementMBean((PasswordCredentialManagingAuthenticationProvider)child, this._objectRegistry) : null;
                }
                if (mbean != null) {
                    this.createAdditionalMBeansFromProviders(child, mbean);
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)("Exception while creating mbean for " + child.getClass().getSimpleName() + " " + child.getName()), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void childRemoved(ConfiguredObject object, ConfiguredObject child) {
        Map<ConfiguredObject, AMQManagedObject> map = this._children;
        synchronized (map) {
            AMQManagedObject mbean = this._children.remove(child);
            if (mbean != null) {
                try {
                    mbean.unregister();
                }
                catch (Exception e) {
                    LOGGER.error((Object)("Exception while unregistering mbean for " + child.getClass().getSimpleName() + " " + child.getName()), (Throwable)e);
                }
            }
        }
    }

    public void attributeSet(ConfiguredObject object, String attributeName, Object oldAttributeValue, Object newAttributeValue) {
    }

    private void createAdditionalMBeansFromProviders(ConfiguredObject child, AMQManagedObject mbean) throws JMException {
        this._children.put(child, mbean);
        QpidServiceLoader qpidServiceLoader = new QpidServiceLoader();
        for (MBeanProvider provider : qpidServiceLoader.instancesOf(MBeanProvider.class)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Consulting mbean provider : " + provider + " for child : " + child));
            }
            if (!provider.isChildManageableByMBean(child)) continue;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"Provider will create mbean");
            }
            provider.createMBean(child, mbean);
        }
    }

    public Collection<String> getAttributeNames() {
        return JMXManagement.getAttributeNames(JMXManagement.class);
    }

    protected void changeAttributes(Map<String, Object> attributes) {
        Map convertedAttributes = MapValueConverter.convert(attributes, ATTRIBUTE_TYPES);
        this.validateAttributes(convertedAttributes);
        super.changeAttributes(convertedAttributes);
    }

    private void validateAttributes(Map<String, Object> convertedAttributes) {
        if (convertedAttributes.containsKey(NAME)) {
            String newName = (String)convertedAttributes.get(NAME);
            if (!this.getName().equals(newName)) {
                throw new IllegalConfigurationException("Changing the name of jmx management plugin is not allowed");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeObjectRegistry() {
        if (this._objectRegistry != null) {
            try {
                this._objectRegistry.close();
            }
            finally {
                this._objectRegistry = null;
            }
        }
    }

    public String getPluginType() {
        return PLUGIN_TYPE;
    }

    @ManagedAttribute
    public boolean getUsePlatformMBeanServer() {
        return (Boolean)this.getAttribute(USE_PLATFORM_MBEAN_SERVER);
    }
}

