/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.jmx.mbeans;

import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import javax.management.JMException;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.apache.qpid.management.common.mbeans.ManagedConnection;
import org.apache.qpid.server.jmx.ManagedObject;
import org.apache.qpid.server.jmx.mbeans.AbstractStatisticsGatheringMBean;
import org.apache.qpid.server.jmx.mbeans.VirtualHostMBean;
import org.apache.qpid.server.model.Connection;
import org.apache.qpid.server.model.Session;
import org.apache.qpid.server.util.ServerScopedRuntimeException;

public class ConnectionMBean
extends AbstractStatisticsGatheringMBean<Connection>
implements ManagedConnection {
    private static final OpenType[] CHANNEL_ATTRIBUTE_TYPES = new OpenType[]{SimpleType.INTEGER, SimpleType.BOOLEAN, SimpleType.STRING, SimpleType.INTEGER, SimpleType.BOOLEAN};
    private static final CompositeType CHANNEL_TYPE;
    private static final TabularType CHANNELS_TYPE;
    private final VirtualHostMBean _virtualHostMBean;

    public ConnectionMBean(Connection conn, VirtualHostMBean virtualHostMBean) throws JMException {
        super(ManagedConnection.class, "Connection", virtualHostMBean.getRegistry(), conn);
        this._virtualHostMBean = virtualHostMBean;
        this.register();
    }

    @Override
    protected long getBytesOut() {
        return ((Connection)this.getConfiguredObject()).getBytesOut();
    }

    @Override
    protected long getBytesIn() {
        return ((Connection)this.getConfiguredObject()).getBytesIn();
    }

    @Override
    protected long getMessagesOut() {
        return ((Connection)this.getConfiguredObject()).getMessagesOut();
    }

    @Override
    protected long getMessagesIn() {
        return ((Connection)this.getConfiguredObject()).getMessagesIn();
    }

    @Override
    public String getObjectInstanceName() {
        return ObjectName.quote(this.getRemoteAddress());
    }

    @Override
    public ManagedObject getParentObject() {
        return this._virtualHostMBean;
    }

    public String getClientId() {
        return (String)((Connection)this.getConfiguredObject()).getAttribute("clientId");
    }

    public String getAuthorizedId() {
        return (String)((Connection)this.getConfiguredObject()).getAttribute("principal");
    }

    public String getVersion() {
        return (String)((Connection)this.getConfiguredObject()).getAttribute("clientVersion");
    }

    public String getRemoteAddress() {
        return (String)((Connection)this.getConfiguredObject()).getAttribute("remoteAddress");
    }

    public Date getLastIoTime() {
        return new Date(((Connection)this.getConfiguredObject()).getLastIoTime());
    }

    public Long getMaximumNumberOfChannels() {
        return (Long)((Connection)this.getConfiguredObject()).getAttribute("sessionCountLimit");
    }

    public TabularData channels() throws IOException, JMException {
        TabularDataSupport sessionTable = new TabularDataSupport(CHANNELS_TYPE);
        Collection list = ((Connection)this.getConfiguredObject()).getSessions();
        for (Session session : list) {
            Long txnBegins = session.getLocalTransactionBegins();
            Integer channelId = (Integer)session.getAttribute("channelId");
            int unacknowledgedSize = (int)session.getUnacknowledgedMessages();
            boolean blocked = (Boolean)session.getAttribute("producerFlowBlocked");
            boolean isTransactional = txnBegins > 0L;
            Object[] itemValues = new Object[]{channelId, isTransactional, null, unacknowledgedSize, blocked};
            CompositeDataSupport sessionData = new CompositeDataSupport(CHANNEL_TYPE, COMPOSITE_ITEM_NAMES_DESC.toArray(new String[COMPOSITE_ITEM_NAMES_DESC.size()]), itemValues);
            sessionTable.put(sessionData);
        }
        return sessionTable;
    }

    public void commitTransactions(int channelId) throws JMException {
        throw this.buildUnsupportedException();
    }

    public void rollbackTransactions(int channelId) throws JMException {
        throw this.buildUnsupportedException();
    }

    public void closeConnection() throws Exception {
        ((Connection)this.getConfiguredObject()).delete();
    }

    public boolean isStatisticsEnabled() {
        return true;
    }

    public void setStatisticsEnabled(boolean enabled) {
        this.updateStats();
    }

    private JMException buildUnsupportedException() throws JMException {
        String msg = "Operation not supported";
        JMException jmException = new JMException(msg);
        jmException.initCause(new UnsupportedOperationException(msg));
        return jmException;
    }

    static {
        try {
            CHANNEL_TYPE = new CompositeType("Channel", "Channel Details", COMPOSITE_ITEM_NAMES_DESC.toArray(new String[COMPOSITE_ITEM_NAMES_DESC.size()]), COMPOSITE_ITEM_NAMES_DESC.toArray(new String[COMPOSITE_ITEM_NAMES_DESC.size()]), CHANNEL_ATTRIBUTE_TYPES);
            CHANNELS_TYPE = new TabularType("Channels", "Channels", CHANNEL_TYPE, TABULAR_UNIQUE_INDEX.toArray(new String[TABULAR_UNIQUE_INDEX.size()]));
        }
        catch (JMException ex) {
            throw new ServerScopedRuntimeException("Got JMException in static initializer.", (Throwable)ex);
        }
    }
}

