/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.jmx.mbeans;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.management.JMException;
import org.apache.log4j.Logger;
import org.apache.qpid.server.jmx.DefaultManagedObject;
import org.apache.qpid.server.jmx.ManagedObject;
import org.apache.qpid.server.jmx.ManagedObjectRegistry;
import org.apache.qpid.server.jmx.mbeans.ShutdownMBean;

public class Shutdown
extends DefaultManagedObject
implements ShutdownMBean {
    private static final Logger _logger = Logger.getLogger(Shutdown.class);
    private static final String FORMAT = "yyyy/MM/dd HH:mm:ss";
    private static final int THREAD_COUNT = 1;
    private static final ScheduledExecutorService EXECUTOR = new ScheduledThreadPoolExecutor(1);
    private final Runnable _shutdown = new SystemExiter();

    public Shutdown(ManagedObjectRegistry registry) throws JMException {
        super(ShutdownMBean.class, "Shutdown", registry);
        this.register();
    }

    @Override
    public void shutdown() {
        _logger.info((Object)"Shutting down at user's request");
        this.shutdownBroker(0L);
    }

    @Override
    public void shutdown(long delay) {
        if (delay < 0L) {
            _logger.info((Object)"Shutting down at user's request");
            this.shutdownBroker(0L);
        } else {
            _logger.info((Object)("Scheduled broker shutdown after " + delay + "ms"));
            this.shutdownBroker(delay);
        }
    }

    @Override
    public void shutdownAt(String when) {
        Date date;
        SimpleDateFormat df = new SimpleDateFormat(FORMAT);
        try {
            date = df.parse(when);
        }
        catch (ParseException e) {
            _logger.error((Object)("Invalid date \"" + when + "\": expecting " + FORMAT), (Throwable)e);
            return;
        }
        _logger.info((Object)("Scheduled broker shutdown at " + when));
        long now = System.currentTimeMillis();
        long time = date.getTime();
        if (time > now) {
            this.shutdownBroker(time - now);
        } else {
            this.shutdownBroker(0L);
        }
    }

    private void shutdownBroker(long delay) {
        EXECUTOR.schedule(this._shutdown, delay, TimeUnit.MILLISECONDS);
    }

    @Override
    public ManagedObject getParentObject() {
        return null;
    }

    @Override
    public String getObjectInstanceName() {
        return "Shutdown";
    }

    class SystemExiter
    implements Runnable {
        SystemExiter() {
        }

        @Override
        public void run() {
            System.exit(0);
        }
    }
}

