/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.qmf;

import java.util.List;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.apache.qpid.AMQException;
import org.apache.qpid.qmf.QMFClass;
import org.apache.qpid.qmf.QMFCommand;
import org.apache.qpid.qmf.QMFCommandCompletionCommand;
import org.apache.qpid.qmf.QMFCommandHeader;
import org.apache.qpid.qmf.QMFMessage;
import org.apache.qpid.qmf.QMFMethod;
import org.apache.qpid.qmf.QMFMethodInvocation;
import org.apache.qpid.qmf.QMFObject;
import org.apache.qpid.qmf.QMFPackage;
import org.apache.qpid.qmf.QMFService;
import org.apache.qpid.server.exchange.Exchange;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.queue.BaseQueue;
import org.apache.qpid.server.virtualhost.VirtualHost;
import org.apache.qpid.transport.codec.BBDecoder;

public class QMFMethodRequestCommand
extends QMFCommand {
    private static final Logger _qmfLogger = Logger.getLogger((String)"qpid.qmf");
    private QMFMethodInvocation _methodInstance;
    private QMFObject _object;

    public QMFMethodRequestCommand(QMFCommandHeader header, BBDecoder decoder, QMFService qmfService) {
        super(header);
        UUID objectId = decoder.readUuid();
        String packageName = decoder.readStr8();
        String className = decoder.readStr8();
        byte[] hash = decoder.readBin128();
        String methodName = decoder.readStr8();
        QMFPackage qmfPackage = qmfService.getPackage(packageName);
        QMFClass qmfClass = qmfPackage.getQMFClass(className);
        this._object = qmfService.getObjectById(qmfClass, objectId);
        QMFMethod method = qmfClass.getMethod(methodName);
        this._methodInstance = method.parse(decoder);
    }

    public void process(VirtualHost virtualHost, ServerMessage message) {
        String exchangeName = message.getMessageHeader().getReplyToExchange();
        String queueName = message.getMessageHeader().getReplyToRoutingKey();
        QMFCommand[] commands = new QMFCommand[2];
        _qmfLogger.debug((Object)("Execute: " + this._methodInstance + " on " + this._object));
        commands[0] = this._methodInstance.execute(this._object, this);
        commands[1] = new QMFCommandCompletionCommand(this);
        Exchange exchange = virtualHost.getExchangeRegistry().getExchange(exchangeName);
        for (QMFCommand cmd : commands) {
            QMFMessage responseMessage = new QMFMessage(queueName, cmd);
            List<? extends BaseQueue> queues = exchange.route(responseMessage);
            for (BaseQueue baseQueue : queues) {
                try {
                    baseQueue.enqueue(responseMessage);
                }
                catch (AMQException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

