/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.exchange.topic;

import java.util.concurrent.ConcurrentHashMap;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.server.exchange.topic.TopicWord;

public class TopicWordDictionary {
    private final ConcurrentHashMap<AMQShortString, TopicWord> _dictionary = new ConcurrentHashMap();

    public TopicWordDictionary() {
        this._dictionary.put(new AMQShortString("*"), TopicWord.ANY_WORD);
        this._dictionary.put(new AMQShortString("#"), TopicWord.WILDCARD_WORD);
    }

    public TopicWord getOrCreateWord(AMQShortString name) {
        TopicWord word = this._dictionary.putIfAbsent(name, new TopicWord(name));
        if (word == null) {
            word = this._dictionary.get(name);
        }
        return word;
    }

    public TopicWord getWord(AMQShortString name) {
        TopicWord word = this._dictionary.get(name);
        if (word == null) {
            word = TopicWord.ANY_WORD;
        }
        return word;
    }
}

