/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.filter;

import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.qpid.AMQException;
import org.apache.qpid.AMQInvalidArgumentException;
import org.apache.qpid.common.AMQPFilterTypes;
import org.apache.qpid.filter.SelectorParsingException;
import org.apache.qpid.filter.selector.ParseException;
import org.apache.qpid.filter.selector.TokenMgrError;
import org.apache.qpid.framing.FieldTable;
import org.apache.qpid.server.filter.FilterManager;
import org.apache.qpid.server.filter.JMSSelectorFilter;
import org.apache.qpid.server.filter.SimpleFilterManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterManagerFactory {
    private static final Logger _logger = Logger.getLogger(FilterManagerFactory.class);

    private FilterManagerFactory() {
    }

    public static FilterManager createManager(FieldTable filters) throws AMQException {
        SimpleFilterManager manager = null;
        if (filters != null) {
            String selector;
            if (filters.containsKey(AMQPFilterTypes.JMS_SELECTOR.getValue()) && (selector = filters.getString(AMQPFilterTypes.JMS_SELECTOR.getValue())) != null && !selector.equals("")) {
                manager = new SimpleFilterManager();
                try {
                    manager.add(new JMSSelectorFilter(selector));
                }
                catch (ParseException e) {
                    throw new AMQInvalidArgumentException("Cannot parse JMS selector \"" + selector + "\"", (Throwable)e);
                }
                catch (SelectorParsingException e) {
                    throw new AMQInvalidArgumentException("Cannot parse JMS selector \"" + selector + "\"", (Throwable)e);
                }
                catch (TokenMgrError e) {
                    throw new AMQInvalidArgumentException("Cannot parse JMS selector \"" + selector + "\"", (Throwable)e);
                }
            }
        } else {
            _logger.debug((Object)"No Filters found.");
        }
        return manager;
    }

    public static FilterManager createManager(Map<String, Object> map) throws AMQException {
        return FilterManagerFactory.createManager(FieldTable.convertToFieldTable(map));
    }
}

