/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.flow;

import org.apache.qpid.server.flow.AbstractFlowCreditManager;
import org.apache.qpid.server.flow.FlowCreditManager;

public class MessageAndBytesCreditManager
extends AbstractFlowCreditManager
implements FlowCreditManager {
    private long _messageCredit;
    private long _bytesCredit;

    public MessageAndBytesCreditManager(long messageCredit, long bytesCredit) {
        this._messageCredit = messageCredit;
        this._bytesCredit = bytesCredit;
    }

    public synchronized long getMessageCredit() {
        return this._messageCredit;
    }

    public synchronized long getBytesCredit() {
        return this._bytesCredit;
    }

    public synchronized void restoreCredit(long messageCredit, long bytesCredit) {
        this._messageCredit += messageCredit;
        this._bytesCredit += bytesCredit;
        this.setSuspended(this.hasCredit());
    }

    public synchronized void removeAllCredit() {
        this._messageCredit = 0L;
        this._bytesCredit = 0L;
        this.setSuspended(true);
    }

    public synchronized boolean hasCredit() {
        return this._messageCredit > 0L && this._bytesCredit > 0L;
    }

    public synchronized boolean useCreditForMessage(long msgSize) {
        if (this._messageCredit == 0L) {
            this.setSuspended(true);
            return false;
        }
        if (msgSize > this._bytesCredit) {
            this.setSuspended(true);
            return false;
        }
        --this._messageCredit;
        this._bytesCredit -= msgSize;
        this.setSuspended(false);
        return true;
    }

    public synchronized void setBytesCredit(long bytesCredit) {
        this._bytesCredit = bytesCredit;
    }
}

