/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.handler;

import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.apache.qpid.AMQException;
import org.apache.qpid.framing.AMQDataBlock;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.FieldTable;
import org.apache.qpid.framing.MethodRegistry;
import org.apache.qpid.framing.QueueDeclareBody;
import org.apache.qpid.framing.QueueDeclareOkBody;
import org.apache.qpid.protocol.AMQConstant;
import org.apache.qpid.server.AMQChannel;
import org.apache.qpid.server.exchange.Exchange;
import org.apache.qpid.server.exchange.ExchangeRegistry;
import org.apache.qpid.server.model.UUIDGenerator;
import org.apache.qpid.server.protocol.AMQProtocolSession;
import org.apache.qpid.server.protocol.AMQSessionModel;
import org.apache.qpid.server.queue.AMQQueue;
import org.apache.qpid.server.queue.AMQQueueFactory;
import org.apache.qpid.server.queue.QueueRegistry;
import org.apache.qpid.server.registry.ApplicationRegistry;
import org.apache.qpid.server.state.AMQStateManager;
import org.apache.qpid.server.state.StateAwareMethodListener;
import org.apache.qpid.server.store.MessageStore;
import org.apache.qpid.server.virtualhost.VirtualHost;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueueDeclareHandler
implements StateAwareMethodListener<QueueDeclareBody> {
    private static final Logger _logger = Logger.getLogger(QueueDeclareHandler.class);
    private static final QueueDeclareHandler _instance = new QueueDeclareHandler();
    private boolean autoRegister = ApplicationRegistry.getInstance().getConfiguration().getQueueAutoRegister();

    public static QueueDeclareHandler getInstance() {
        return _instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void methodReceived(AMQStateManager stateManager, QueueDeclareBody body, int channelId) throws AMQException {
        AMQQueue queue;
        final AMQProtocolSession protocolConnection = stateManager.getProtocolSession();
        AMQChannel session = protocolConnection.getChannel(channelId);
        VirtualHost virtualHost = protocolConnection.getVirtualHost();
        ExchangeRegistry exchangeRegistry = virtualHost.getExchangeRegistry();
        QueueRegistry queueRegistry = virtualHost.getQueueRegistry();
        MessageStore store = virtualHost.getMessageStore();
        AMQShortString queueName = body.getQueue() == null || body.getQueue().length() == 0 ? this.createName() : body.getQueue().intern();
        AMQChannel channel = protocolConnection.getChannel(channelId);
        if (channel == null) {
            throw body.getChannelNotFoundException(channelId);
        }
        QueueRegistry queueRegistry2 = queueRegistry;
        synchronized (queueRegistry2) {
            queue = queueRegistry.getQueue(queueName);
            AMQSessionModel owningSession = null;
            if (queue != null) {
                owningSession = queue.getExclusiveOwningSession();
            }
            if (queue == null) {
                if (body.getPassive()) {
                    String msg = "Queue: " + queueName + " not found on VirtualHost(" + virtualHost + ").";
                    throw body.getChannelException(AMQConstant.NOT_FOUND, msg);
                }
                queue = this.createQueue(queueName, body, virtualHost, protocolConnection);
                queue.setAuthorizationHolder(protocolConnection);
                if (queue.isDurable() && !queue.isAutoDelete()) {
                    store.createQueue(queue, body.getArguments());
                }
                if (body.getAutoDelete()) {
                    queue.setDeleteOnNoConsumers(true);
                }
                queueRegistry.registerQueue(queue);
                if (body.getExclusive()) {
                    queue.setExclusiveOwningSession(protocolConnection.getChannel(channelId));
                    queue.setAuthorizationHolder(protocolConnection);
                    if (!body.getDurable()) {
                        final AMQQueue q = queue;
                        final AMQProtocolSession.Task sessionCloseTask = new AMQProtocolSession.Task(){

                            public void doTask(AMQProtocolSession session) throws AMQException {
                                q.setExclusiveOwningSession(null);
                            }
                        };
                        protocolConnection.addSessionCloseTask(sessionCloseTask);
                        queue.addQueueDeleteTask(new AMQQueue.Task(){

                            public void doTask(AMQQueue queue) throws AMQException {
                                protocolConnection.removeSessionCloseTask(sessionCloseTask);
                            }
                        });
                    }
                }
                if (this.autoRegister) {
                    Exchange defaultExchange = exchangeRegistry.getDefaultExchange();
                    virtualHost.getBindingFactory().addBinding(String.valueOf(queueName), queue, defaultExchange, Collections.EMPTY_MAP);
                    _logger.info((Object)("Queue " + queueName + " bound to default exchange(" + defaultExchange.getNameShortString() + ")"));
                }
            } else {
                if (queue.isExclusive() && !queue.isDurable() && (owningSession == null || owningSession.getConnectionModel() != protocolConnection)) {
                    throw body.getConnectionException(AMQConstant.NOT_ALLOWED, "Queue " + queue.getNameShortString() + " is exclusive, but not created on this Connection.");
                }
                if (!body.getPassive() && queue.isExclusive() != body.getExclusive()) {
                    throw body.getChannelException(AMQConstant.ALREADY_EXISTS, "Cannot re-declare queue '" + queue.getNameShortString() + "' with different exclusivity (was: " + queue.isExclusive() + " requested " + body.getExclusive() + ")");
                }
                if (!body.getPassive() && body.getExclusive() && !(!queue.isDurable() ? owningSession == null || owningSession.getConnectionModel() == protocolConnection : String.valueOf(queue.getOwner()).equals(session.getClientID()))) {
                    throw body.getChannelException(AMQConstant.ALREADY_EXISTS, "Cannot declare queue('" + queueName + "'), " + "as exclusive queue with same name " + "declared on another client ID('" + queue.getOwner() + "') your clientID('" + session.getClientID() + "')");
                }
                if (!body.getPassive() && queue.isAutoDelete() != body.getAutoDelete()) {
                    throw body.getChannelException(AMQConstant.ALREADY_EXISTS, "Cannot re-declare queue '" + queue.getNameShortString() + "' with different auto-delete (was: " + queue.isAutoDelete() + " requested " + body.getAutoDelete() + ")");
                }
                if (!body.getPassive() && queue.isDurable() != body.getDurable()) {
                    throw body.getChannelException(AMQConstant.ALREADY_EXISTS, "Cannot re-declare queue '" + queue.getNameShortString() + "' with different durability (was: " + queue.isDurable() + " requested " + body.getDurable() + ")");
                }
            }
            channel.setDefaultQueue(queue);
        }
        if (!body.getNowait()) {
            channel.sync();
            MethodRegistry methodRegistry = protocolConnection.getMethodRegistry();
            QueueDeclareOkBody responseBody = methodRegistry.createQueueDeclareOkBody(queueName, (long)queue.getMessageCount(), (long)queue.getConsumerCount());
            protocolConnection.writeFrame((AMQDataBlock)responseBody.generateFrame(channelId));
            _logger.info((Object)("Queue " + queueName + " declared successfully"));
        }
    }

    protected AMQShortString createName() {
        return new AMQShortString("tmp_" + UUID.randomUUID());
    }

    protected AMQQueue createQueue(final AMQShortString queueName, QueueDeclareBody body, VirtualHost virtualHost, final AMQProtocolSession session) throws AMQException {
        final QueueRegistry registry = virtualHost.getQueueRegistry();
        String owner = body.getExclusive() ? AMQShortString.toString((AMQShortString)session.getContextKey()) : null;
        Map arguments = FieldTable.convertToMap((FieldTable)body.getArguments());
        String queueNameString = AMQShortString.toString((AMQShortString)queueName);
        final AMQQueue queue = AMQQueueFactory.createAMQQueueImpl(UUIDGenerator.generateQueueUUID(queueNameString, virtualHost.getName()), queueNameString, body.getDurable(), owner, body.getAutoDelete(), body.getExclusive(), virtualHost, arguments);
        if (body.getExclusive() && !body.getDurable()) {
            final AMQProtocolSession.Task deleteQueueTask = new AMQProtocolSession.Task(){

                public void doTask(AMQProtocolSession session) throws AMQException {
                    if (registry.getQueue(queueName) == queue) {
                        queue.delete();
                    }
                }
            };
            session.addSessionCloseTask(deleteQueueTask);
            queue.addQueueDeleteTask(new AMQQueue.Task(){

                public void doTask(AMQQueue queue) {
                    session.removeSessionCloseTask(deleteQueueTask);
                }
            });
        }
        return queue;
    }
}

