/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.logging.actors;

import java.security.AccessController;
import java.security.Principal;
import java.text.MessageFormat;
import java.util.Set;
import javax.management.remote.JMXPrincipal;
import javax.security.auth.Subject;
import org.apache.qpid.server.logging.RootMessageLogger;
import org.apache.qpid.server.logging.actors.AbstractActor;

public class ManagementActor
extends AbstractActor {
    private static final String UNKNOWN_PRINCIPAL = "N/A";
    private String _lastThreadName = null;
    public static final String MANAGEMENT_FORMAT = "mng:{0}({1})";
    private String _logString;

    public ManagementActor(RootMessageLogger rootLogger) {
        super(rootLogger);
    }

    private void updateLogString() {
        String currentName = Thread.currentThread().getName();
        if (!currentName.equals(this._lastThreadName)) {
            String actor;
            this._lastThreadName = currentName;
            String[] split = currentName.split("\\(");
            if (split.length == 2) {
                String ip = currentName.split("-")[1];
                String principalName = this.getPrincipalName();
                if (principalName == null) {
                    principalName = UNKNOWN_PRINCIPAL;
                }
                actor = MessageFormat.format(MANAGEMENT_FORMAT, principalName, ip);
            } else {
                actor = currentName;
            }
            this._logString = "[" + actor + "] ";
        }
    }

    protected String getPrincipalName() {
        Set<JMXPrincipal> principals;
        String identity = null;
        Subject subject = Subject.getSubject(AccessController.getContext());
        if (subject != null && (principals = subject.getPrincipals(JMXPrincipal.class)) != null && !principals.isEmpty()) {
            Principal principal = principals.iterator().next();
            identity = principal.getName();
        }
        return identity;
    }

    public String getLogMessage() {
        this.updateLogString();
        return this._logString;
    }
}

