/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.logging.messages;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;
import org.apache.qpid.server.logging.LogMessage;
import org.apache.qpid.server.registry.ApplicationRegistry;

public class ConnectionMessages {
    private static ResourceBundle _messages;
    private static Locale _currentLocale;
    public static final String CONNECTION_LOG_HIERARCHY = "qpid.message.connection";
    public static final String OPEN_LOG_HIERARCHY = "qpid.message.connection.open";
    public static final String CLOSE_LOG_HIERARCHY = "qpid.message.connection.close";

    public static void reload() {
        _currentLocale = ApplicationRegistry.isConfigured() ? ApplicationRegistry.getInstance().getConfiguration().getLocale() : Locale.getDefault();
        _messages = ResourceBundle.getBundle("org.apache.qpid.server.logging.messages.Connection_logmessages", _currentLocale);
    }

    public static LogMessage OPEN(String param1, String param2, String param3, boolean opt1, boolean opt2, boolean opt3) {
        String rawMessage = _messages.getString("OPEN");
        StringBuffer msg = new StringBuffer();
        String[] parts = rawMessage.split("\\[");
        msg.append(parts[0]);
        if (parts.length > 1) {
            int end = parts[1].indexOf(93);
            if (opt1) {
                msg.append(parts[1].substring(0, end));
            }
            msg.append(parts[1].substring(end + 1));
            end = parts[2].indexOf(93);
            if (opt2) {
                msg.append(parts[2].substring(0, end));
            }
            msg.append(parts[2].substring(end + 1));
            end = parts[3].indexOf(93);
            if (opt3) {
                msg.append(parts[3].substring(0, end));
            }
            msg.append(parts[3].substring(end + 1));
        }
        rawMessage = msg.toString();
        Object[] messageArguments = new Object[]{param1, param2, param3};
        MessageFormat formatter = new MessageFormat(rawMessage, _currentLocale);
        final String message = formatter.format(messageArguments);
        return new LogMessage(){

            public String toString() {
                return message;
            }

            public String getLogHierarchy() {
                return ConnectionMessages.OPEN_LOG_HIERARCHY;
            }
        };
    }

    public static LogMessage CLOSE() {
        String rawMessage;
        final String message = rawMessage = _messages.getString("CLOSE");
        return new LogMessage(){

            public String toString() {
                return message;
            }

            public String getLogHierarchy() {
                return ConnectionMessages.CLOSE_LOG_HIERARCHY;
            }
        };
    }

    private ConnectionMessages() {
    }

    static {
        Logger.getLogger((String)CONNECTION_LOG_HIERARCHY);
        Logger.getLogger((String)OPEN_LOG_HIERARCHY);
        Logger.getLogger((String)CLOSE_LOG_HIERARCHY);
        ConnectionMessages.reload();
    }
}

