/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.logging.messages;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;
import org.apache.qpid.server.logging.LogMessage;
import org.apache.qpid.server.registry.ApplicationRegistry;

public class ManagementConsoleMessages {
    private static ResourceBundle _messages;
    private static Locale _currentLocale;
    public static final String MANAGEMENTCONSOLE_LOG_HIERARCHY = "qpid.message.managementconsole";
    public static final String OPEN_LOG_HIERARCHY = "qpid.message.managementconsole.open";
    public static final String LISTENING_LOG_HIERARCHY = "qpid.message.managementconsole.listening";
    public static final String SSL_KEYSTORE_LOG_HIERARCHY = "qpid.message.managementconsole.ssl_keystore";
    public static final String STOPPED_LOG_HIERARCHY = "qpid.message.managementconsole.stopped";
    public static final String CLOSE_LOG_HIERARCHY = "qpid.message.managementconsole.close";
    public static final String SHUTTING_DOWN_LOG_HIERARCHY = "qpid.message.managementconsole.shutting_down";
    public static final String STARTUP_LOG_HIERARCHY = "qpid.message.managementconsole.startup";
    public static final String READY_LOG_HIERARCHY = "qpid.message.managementconsole.ready";

    public static void reload() {
        _currentLocale = ApplicationRegistry.isConfigured() ? ApplicationRegistry.getInstance().getConfiguration().getLocale() : Locale.getDefault();
        _messages = ResourceBundle.getBundle("org.apache.qpid.server.logging.messages.ManagementConsole_logmessages", _currentLocale);
    }

    public static LogMessage OPEN(String param1) {
        String rawMessage = _messages.getString("OPEN");
        Object[] messageArguments = new Object[]{param1};
        MessageFormat formatter = new MessageFormat(rawMessage, _currentLocale);
        final String message = formatter.format(messageArguments);
        return new LogMessage(){

            public String toString() {
                return message;
            }

            public String getLogHierarchy() {
                return ManagementConsoleMessages.OPEN_LOG_HIERARCHY;
            }
        };
    }

    public static LogMessage LISTENING(String param1, Number param2) {
        String rawMessage = _messages.getString("LISTENING");
        Object[] messageArguments = new Object[]{param1, param2};
        MessageFormat formatter = new MessageFormat(rawMessage, _currentLocale);
        final String message = formatter.format(messageArguments);
        return new LogMessage(){

            public String toString() {
                return message;
            }

            public String getLogHierarchy() {
                return ManagementConsoleMessages.LISTENING_LOG_HIERARCHY;
            }
        };
    }

    public static LogMessage SSL_KEYSTORE(String param1) {
        String rawMessage = _messages.getString("SSL_KEYSTORE");
        Object[] messageArguments = new Object[]{param1};
        MessageFormat formatter = new MessageFormat(rawMessage, _currentLocale);
        final String message = formatter.format(messageArguments);
        return new LogMessage(){

            public String toString() {
                return message;
            }

            public String getLogHierarchy() {
                return ManagementConsoleMessages.SSL_KEYSTORE_LOG_HIERARCHY;
            }
        };
    }

    public static LogMessage STOPPED() {
        String rawMessage;
        final String message = rawMessage = _messages.getString("STOPPED");
        return new LogMessage(){

            public String toString() {
                return message;
            }

            public String getLogHierarchy() {
                return ManagementConsoleMessages.STOPPED_LOG_HIERARCHY;
            }
        };
    }

    public static LogMessage CLOSE(String param1) {
        String rawMessage = _messages.getString("CLOSE");
        Object[] messageArguments = new Object[]{param1};
        MessageFormat formatter = new MessageFormat(rawMessage, _currentLocale);
        final String message = formatter.format(messageArguments);
        return new LogMessage(){

            public String toString() {
                return message;
            }

            public String getLogHierarchy() {
                return ManagementConsoleMessages.CLOSE_LOG_HIERARCHY;
            }
        };
    }

    public static LogMessage SHUTTING_DOWN(String param1, Number param2) {
        String rawMessage = _messages.getString("SHUTTING_DOWN");
        Object[] messageArguments = new Object[]{param1, param2};
        MessageFormat formatter = new MessageFormat(rawMessage, _currentLocale);
        final String message = formatter.format(messageArguments);
        return new LogMessage(){

            public String toString() {
                return message;
            }

            public String getLogHierarchy() {
                return ManagementConsoleMessages.SHUTTING_DOWN_LOG_HIERARCHY;
            }
        };
    }

    public static LogMessage STARTUP() {
        String rawMessage;
        final String message = rawMessage = _messages.getString("STARTUP");
        return new LogMessage(){

            public String toString() {
                return message;
            }

            public String getLogHierarchy() {
                return ManagementConsoleMessages.STARTUP_LOG_HIERARCHY;
            }
        };
    }

    public static LogMessage READY(boolean opt1) {
        String rawMessage = _messages.getString("READY");
        StringBuffer msg = new StringBuffer();
        String[] parts = rawMessage.split("\\[");
        msg.append(parts[0]);
        if (parts.length > 1) {
            int end = parts[1].indexOf(93);
            if (opt1) {
                msg.append(parts[1].substring(0, end));
            }
            msg.append(parts[1].substring(end + 1));
        }
        final String message = rawMessage = msg.toString();
        return new LogMessage(){

            public String toString() {
                return message;
            }

            public String getLogHierarchy() {
                return ManagementConsoleMessages.READY_LOG_HIERARCHY;
            }
        };
    }

    private ManagementConsoleMessages() {
    }

    static {
        Logger.getLogger((String)MANAGEMENTCONSOLE_LOG_HIERARCHY);
        Logger.getLogger((String)OPEN_LOG_HIERARCHY);
        Logger.getLogger((String)LISTENING_LOG_HIERARCHY);
        Logger.getLogger((String)SSL_KEYSTORE_LOG_HIERARCHY);
        Logger.getLogger((String)STOPPED_LOG_HIERARCHY);
        Logger.getLogger((String)CLOSE_LOG_HIERARCHY);
        Logger.getLogger((String)SHUTTING_DOWN_LOG_HIERARCHY);
        Logger.getLogger((String)STARTUP_LOG_HIERARCHY);
        Logger.getLogger((String)READY_LOG_HIERARCHY);
        ManagementConsoleMessages.reload();
    }
}

