/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model;

import org.apache.qpid.server.model.ConfiguredObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Attribute<C extends ConfiguredObject, T> {
    private final String _name;

    public Attribute(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public abstract Class<T> getType();

    public T getValue(C configuredObject) {
        Object o = configuredObject.getAttribute(this._name);
        if (this.getType().isInstance(o)) {
            return (T)o;
        }
        return null;
    }

    public T setValue(T expected, T desired, C configuredObject) {
        return (T)configuredObject.setAttribute(this._name, expected, desired);
    }

    public abstract T setValue(String var1, C var2);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FloatAttribute<C extends ConfiguredObject>
    extends Attribute<C, Float> {
        public FloatAttribute(String name) {
            super(name);
        }

        @Override
        public Class<Float> getType() {
            return Float.class;
        }

        @Override
        public Float setValue(String stringValue, C configuredObject) {
            try {
                Float val = Float.valueOf(stringValue);
                return this.setValue(this.getValue(configuredObject), val, configuredObject);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DoubleAttribute<C extends ConfiguredObject>
    extends Attribute<C, Double> {
        public DoubleAttribute(String name) {
            super(name);
        }

        @Override
        public Class<Double> getType() {
            return Double.class;
        }

        @Override
        public Double setValue(String stringValue, C configuredObject) {
            try {
                Double val = Double.valueOf(stringValue);
                return this.setValue(this.getValue(configuredObject), val, configuredObject);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class LongAttribute<C extends ConfiguredObject>
    extends Attribute<C, Long> {
        public LongAttribute(String name) {
            super(name);
        }

        @Override
        public Class<Long> getType() {
            return Long.class;
        }

        @Override
        public Long setValue(String stringValue, C configuredObject) {
            try {
                Long val = Long.valueOf(stringValue);
                return this.setValue(this.getValue(configuredObject), val, configuredObject);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class IntegerAttribute<C extends ConfiguredObject>
    extends Attribute<C, Integer> {
        public IntegerAttribute(String name) {
            super(name);
        }

        @Override
        public Class<Integer> getType() {
            return Integer.class;
        }

        @Override
        public Integer setValue(String stringValue, C configuredObject) {
            try {
                Integer val = Integer.valueOf(stringValue);
                return this.setValue(this.getValue(configuredObject), val, configuredObject);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class StringAttribute<C extends ConfiguredObject>
    extends Attribute<C, String> {
        public StringAttribute(String name) {
            super(name);
        }

        @Override
        public Class<String> getType() {
            return String.class;
        }

        @Override
        public String setValue(String stringValue, C configuredObject) {
            return this.setValue(this.getValue(configuredObject), stringValue, configuredObject);
        }
    }
}

