/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model;

import java.security.AccessControlException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.qpid.server.model.AuthenticationProvider;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.LifetimePolicy;
import org.apache.qpid.server.model.Port;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.VirtualHost;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface Broker
extends ConfiguredObject {
    public static final String BUILD_VERSION = "buildVersion";
    public static final String BYTES_RETAINED = "bytesRetained";
    public static final String OPERATING_SYSTEM = "operatingSystem";
    public static final String PLATFORM = "platform";
    public static final String PROCESS_PID = "processPid";
    public static final String PRODUCT_VERSION = "productVersion";
    public static final String SUPPORTED_STORE_TYPES = "supportedStoreTypes";
    public static final String CREATED = "created";
    public static final String DURABLE = "durable";
    public static final String ID = "id";
    public static final String LIFETIME_POLICY = "lifetimePolicy";
    public static final String NAME = "name";
    public static final String STATE = "state";
    public static final String TIME_TO_LIVE = "timeToLive";
    public static final String UPDATED = "updated";
    public static final Collection<String> AVAILABLE_ATTRIBUTES = Collections.unmodifiableList(Arrays.asList("buildVersion", "bytesRetained", "operatingSystem", "platform", "processPid", "productVersion", "supportedStoreTypes", "created", "durable", "id", "lifetimePolicy", "name", "state", "timeToLive", "updated"));

    public Collection<VirtualHost> getVirtualHosts();

    public Collection<Port> getPorts();

    public Collection<AuthenticationProvider> getAuthenticationProviders();

    public VirtualHost createVirtualHost(String var1, State var2, boolean var3, LifetimePolicy var4, long var5, Map<String, Object> var7) throws AccessControlException, IllegalArgumentException;

    public void deleteVirtualHost(VirtualHost var1) throws AccessControlException, IllegalStateException;
}

