/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model.adapter;

import java.io.IOException;
import java.security.AccessControlException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.login.AccountNotFoundException;
import org.apache.log4j.Logger;
import org.apache.qpid.server.model.AuthenticationProvider;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.IllegalStateTransitionException;
import org.apache.qpid.server.model.LifetimePolicy;
import org.apache.qpid.server.model.PasswordCredentialManagingAuthenticationProvider;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.Statistics;
import org.apache.qpid.server.model.UUIDGenerator;
import org.apache.qpid.server.model.User;
import org.apache.qpid.server.model.VirtualHostAlias;
import org.apache.qpid.server.model.adapter.AbstractAdapter;
import org.apache.qpid.server.model.adapter.BrokerAdapter;
import org.apache.qpid.server.model.adapter.NoStatistics;
import org.apache.qpid.server.registry.ApplicationRegistry;
import org.apache.qpid.server.security.SecurityManager;
import org.apache.qpid.server.security.access.Operation;
import org.apache.qpid.server.security.auth.database.PrincipalDatabase;
import org.apache.qpid.server.security.auth.manager.AuthenticationManager;
import org.apache.qpid.server.security.auth.manager.PrincipalDatabaseAuthenticationManager;
import org.apache.qpid.server.security.auth.sasl.UsernamePrincipal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AuthenticationProviderAdapter<T extends AuthenticationManager>
extends AbstractAdapter
implements AuthenticationProvider {
    private static final Logger LOGGER = Logger.getLogger(AuthenticationProviderAdapter.class);
    private final BrokerAdapter _broker;
    private final T _authManager;

    private AuthenticationProviderAdapter(BrokerAdapter brokerAdapter, T authManager) {
        super(UUIDGenerator.generateRandomUUID());
        this._broker = brokerAdapter;
        this._authManager = authManager;
    }

    public static AuthenticationProviderAdapter createAuthenticationProviderAdapter(BrokerAdapter brokerAdapter, AuthenticationManager authManager) {
        return authManager instanceof PrincipalDatabaseAuthenticationManager ? new PrincipalDatabaseAuthenticationManagerAdapter(brokerAdapter, (PrincipalDatabaseAuthenticationManager)authManager) : new SimpleAuthenticationProviderAdapter(brokerAdapter, authManager);
    }

    T getAuthManager() {
        return this._authManager;
    }

    @Override
    public Collection<VirtualHostAlias> getVirtualHostPortBindings() {
        return Collections.emptyList();
    }

    @Override
    public String getName() {
        return this._authManager.getClass().getSimpleName();
    }

    @Override
    public String setName(String currentName, String desiredName) throws IllegalStateException, AccessControlException {
        return null;
    }

    @Override
    public State getActualState() {
        return null;
    }

    @Override
    public boolean isDurable() {
        return true;
    }

    @Override
    public void setDurable(boolean durable) throws IllegalStateException, AccessControlException, IllegalArgumentException {
    }

    @Override
    public LifetimePolicy getLifetimePolicy() {
        return LifetimePolicy.PERMANENT;
    }

    @Override
    public LifetimePolicy setLifetimePolicy(LifetimePolicy expected, LifetimePolicy desired) throws IllegalStateException, AccessControlException, IllegalArgumentException {
        return null;
    }

    @Override
    public long getTimeToLive() {
        return 0L;
    }

    @Override
    public long setTimeToLive(long expected, long desired) throws IllegalStateException, AccessControlException, IllegalArgumentException {
        return 0L;
    }

    @Override
    public Statistics getStatistics() {
        return NoStatistics.getInstance();
    }

    @Override
    public Collection<String> getAttributeNames() {
        return AuthenticationProvider.AVAILABLE_ATTRIBUTES;
    }

    @Override
    public Object getAttribute(String name) {
        if ("type".equals(name)) {
            return this._authManager.getClass().getSimpleName();
        }
        if (!"created".equals(name)) {
            if ("durable".equals(name)) {
                return true;
            }
            if ("id".equals(name)) {
                return this.getId();
            }
            if ("lifetimePolicy".equals(name)) {
                return LifetimePolicy.PERMANENT;
            }
            if ("name".equals(name)) {
                return this.getName();
            }
            if ("state".equals(name)) {
                return State.ACTIVE;
            }
            if ("timeToLive".equals(name) || "updated".equals(name)) {
                // empty if block
            }
        }
        return super.getAttribute(name);
    }

    @Override
    public <C extends ConfiguredObject> Collection<C> getChildren(Class<C> clazz) {
        return null;
    }

    @Override
    public <C extends ConfiguredObject> C createChild(Class<C> childClass, Map<String, Object> attributes, ConfiguredObject ... otherParents) {
        return null;
    }

    /* synthetic */ AuthenticationProviderAdapter(BrokerAdapter x0, AuthenticationManager x1, 1 x2) {
        this(x0, x1);
    }

    static class 1 {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PrincipalDatabaseAuthenticationManagerAdapter
    extends AuthenticationProviderAdapter<PrincipalDatabaseAuthenticationManager>
    implements PasswordCredentialManagingAuthenticationProvider {
        public PrincipalDatabaseAuthenticationManagerAdapter(BrokerAdapter brokerAdapter, PrincipalDatabaseAuthenticationManager authManager) {
            super(brokerAdapter, authManager, null);
        }

        @Override
        public boolean createUser(String username, String password, Map<String, String> attributes) {
            return this.getPrincipalDatabase().createPrincipal(new UsernamePrincipal(username), password.toCharArray());
        }

        @Override
        public void deleteUser(String username) throws AccountNotFoundException {
            if (!this.getSecurityManager().authoriseMethod(Operation.DELETE, "UserManagement", "deleteUser")) {
                throw new AccessControlException("Cannot delete user " + username);
            }
            this.getPrincipalDatabase().deletePrincipal(new UsernamePrincipal(username));
        }

        private SecurityManager getSecurityManager() {
            return ApplicationRegistry.getInstance().getSecurityManager();
        }

        private PrincipalDatabase getPrincipalDatabase() {
            return ((PrincipalDatabaseAuthenticationManager)this.getAuthManager()).getPrincipalDatabase();
        }

        @Override
        public void setPassword(String username, String password) throws AccountNotFoundException {
            this.getPrincipalDatabase().updatePassword(new UsernamePrincipal(username), password.toCharArray());
        }

        @Override
        public void reload() throws IOException {
            if (!this.getSecurityManager().authoriseMethod(Operation.UPDATE, "UserManagement", "reload")) {
                throw new AccessControlException("Do not have permission to reload principal database");
            }
            this.getPrincipalDatabase().reload();
        }

        @Override
        public Map<String, Map<String, String>> getUsers() {
            HashMap<String, Map<String, String>> users = new HashMap<String, Map<String, String>>();
            for (Principal principal : this.getPrincipalDatabase().getUsers()) {
                users.put(principal.getName(), Collections.EMPTY_MAP);
            }
            return users;
        }

        @Override
        public <C extends ConfiguredObject> C createChild(Class<C> childClass, Map<String, Object> attributes, ConfiguredObject ... otherParents) {
            if (childClass == User.class) {
                UsernamePrincipal p = new UsernamePrincipal((String)attributes.get("name"));
                if (this.getSecurityManager().authoriseMethod(Operation.UPDATE, "UserManagement", "createUser")) {
                    if (this.getPrincipalDatabase().createPrincipal(p, ((String)attributes.get("password")).toCharArray())) {
                        return (C)new PrincipalAdapter(p);
                    }
                } else {
                    throw new AccessControlException("Do not have permission to create a new user");
                }
            }
            return super.createChild(childClass, attributes, otherParents);
        }

        @Override
        public <C extends ConfiguredObject> Collection<C> getChildren(Class<C> clazz) {
            if (clazz == User.class) {
                List<Principal> users = this.getPrincipalDatabase().getUsers();
                ArrayList<PrincipalAdapter> principals = new ArrayList<PrincipalAdapter>(users.size());
                for (Principal user : users) {
                    principals.add(new PrincipalAdapter(user));
                }
                return Collections.unmodifiableCollection(principals);
            }
            return super.getChildren(clazz);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class PrincipalAdapter
        extends AbstractAdapter
        implements User {
            private final Principal _user;

            public PrincipalAdapter(Principal user) {
                super(UUIDGenerator.generateUserUUID(PrincipalDatabaseAuthenticationManagerAdapter.this.getName(), user.getName()));
                this._user = user;
            }

            @Override
            public String getPassword() {
                return null;
            }

            @Override
            public void setPassword(String password) {
                try {
                    PrincipalDatabaseAuthenticationManagerAdapter.this.setPassword(this._user.getName(), password);
                }
                catch (AccountNotFoundException e) {
                    throw new IllegalStateException(e);
                }
            }

            @Override
            public String getName() {
                return this._user.getName();
            }

            @Override
            public String setName(String currentName, String desiredName) throws IllegalStateException, AccessControlException {
                throw new IllegalStateException("Names cannot be updated");
            }

            @Override
            public State getActualState() {
                return State.ACTIVE;
            }

            @Override
            public boolean isDurable() {
                return true;
            }

            @Override
            public void setDurable(boolean durable) throws IllegalStateException, AccessControlException, IllegalArgumentException {
                throw new IllegalStateException("Durability cannot be updated");
            }

            @Override
            public LifetimePolicy getLifetimePolicy() {
                return LifetimePolicy.PERMANENT;
            }

            @Override
            public LifetimePolicy setLifetimePolicy(LifetimePolicy expected, LifetimePolicy desired) throws IllegalStateException, AccessControlException, IllegalArgumentException {
                throw new IllegalStateException("LifetimePolicy cannot be updated");
            }

            @Override
            public long getTimeToLive() {
                return 0L;
            }

            @Override
            public long setTimeToLive(long expected, long desired) throws IllegalStateException, AccessControlException, IllegalArgumentException {
                throw new IllegalStateException("ttl cannot be updated");
            }

            @Override
            public Statistics getStatistics() {
                return NoStatistics.getInstance();
            }

            @Override
            public <C extends ConfiguredObject> Collection<C> getChildren(Class<C> clazz) {
                return null;
            }

            @Override
            public <C extends ConfiguredObject> C createChild(Class<C> childClass, Map<String, Object> attributes, ConfiguredObject ... otherParents) {
                return null;
            }

            @Override
            public Collection<String> getAttributeNames() {
                return User.AVAILABLE_ATTRIBUTES;
            }

            @Override
            public Object getAttribute(String name) {
                if ("id".equals(name)) {
                    return this.getId();
                }
                if ("name".equals(name)) {
                    return this.getName();
                }
                return super.getAttribute(name);
            }

            @Override
            public Object setAttribute(String name, Object expected, Object desired) throws IllegalStateException, AccessControlException, IllegalArgumentException {
                if (name.equals("password")) {
                    this.setPassword((String)desired);
                }
                return super.setAttribute(name, expected, desired);
            }

            @Override
            public State setDesiredState(State currentState, State desiredState) throws IllegalStateTransitionException, AccessControlException {
                if (desiredState == State.DELETED) {
                    try {
                        PrincipalDatabaseAuthenticationManagerAdapter.this.deleteUser(this._user.getName());
                    }
                    catch (AccountNotFoundException e) {
                        LOGGER.warn((Object)("Failed to delete user " + this._user), (Throwable)e);
                    }
                    return State.DELETED;
                }
                return super.setDesiredState(currentState, desiredState);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SimpleAuthenticationProviderAdapter
    extends AuthenticationProviderAdapter<AuthenticationManager> {
        public SimpleAuthenticationProviderAdapter(BrokerAdapter brokerAdapter, AuthenticationManager authManager) {
            super(brokerAdapter, authManager, null);
        }
    }
}

