/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0;

import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.server.configuration.SessionConfig;
import org.apache.qpid.server.message.InboundMessage;
import org.apache.qpid.server.message.MessageMetaData_1_0;
import org.apache.qpid.server.message.MessageReference;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.protocol.v1_0.Session_1_0;
import org.apache.qpid.server.store.StoredMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Message_1_0
implements ServerMessage,
InboundMessage {
    private final StoredMessage<MessageMetaData_1_0> _storedMessage;
    private List<ByteBuffer> _fragments;
    private WeakReference<Session_1_0> _session;

    public Message_1_0(StoredMessage<MessageMetaData_1_0> storedMessage, List<ByteBuffer> fragments, Session_1_0 session) {
        this._storedMessage = storedMessage;
        this._fragments = fragments;
        this._session = new WeakReference<Session_1_0>(session);
    }

    @Override
    public String getRoutingKey() {
        Object routingKey = this.getMessageHeader().getHeader("routing-key");
        if (routingKey != null) {
            return routingKey.toString();
        }
        return this.getMessageHeader().getSubject();
    }

    @Override
    public AMQShortString getRoutingKeyShortString() {
        return AMQShortString.valueOf((String)this.getRoutingKey());
    }

    private MessageMetaData_1_0 getMessageMetaData() {
        return this._storedMessage.getMetaData();
    }

    @Override
    public MessageMetaData_1_0.MessageHeader_1_0 getMessageHeader() {
        return this.getMessageMetaData().getMessageHeader();
    }

    @Override
    public StoredMessage getStoredMessage() {
        return this._storedMessage;
    }

    @Override
    public boolean isPersistent() {
        return this.getMessageMetaData().isPersistent();
    }

    @Override
    public boolean isRedelivered() {
        return false;
    }

    @Override
    public long getSize() {
        return 0L;
    }

    @Override
    public boolean isImmediate() {
        return false;
    }

    @Override
    public long getExpiration() {
        return this.getMessageHeader().getExpiration();
    }

    @Override
    public MessageReference<Message_1_0> newReference() {
        return new Reference(this);
    }

    @Override
    public long getMessageNumber() {
        return this._storedMessage.getMessageNumber();
    }

    @Override
    public long getArrivalTime() {
        return 0L;
    }

    @Override
    public int getContent(ByteBuffer buf, int offset) {
        return this._storedMessage.getContent(offset, buf);
    }

    @Override
    public ByteBuffer getContent(int offset, int size) {
        ByteBuffer buf = ByteBuffer.allocate(size);
        buf.limit(this.getContent(buf, offset));
        return buf;
    }

    public SessionConfig getSessionConfig() {
        return null;
    }

    public List<ByteBuffer> getFragments() {
        return this._fragments;
    }

    public Session_1_0 getSession() {
        return (Session_1_0)this._session.get();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Reference
    extends MessageReference<Message_1_0> {
        public Reference(Message_1_0 message) {
            super(message);
        }

        @Override
        protected void onReference(Message_1_0 message) {
        }

        @Override
        protected void onRelease(Message_1_0 message) {
        }
    }
}

