/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.queue;

import org.apache.log4j.Logger;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.queue.AMQQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum NotificationCheck {
    MESSAGE_COUNT_ALERT{

        @Override
        public boolean notifyIfNecessary(ServerMessage<?> msg, AMQQueue queue, AMQQueue.NotificationListener listener) {
            int msgCount;
            long maximumMessageCount = queue.getMaximumMessageCount();
            if (maximumMessageCount != 0L && (long)(msgCount = queue.getMessageCount()) >= maximumMessageCount) {
                String notificationMsg = msgCount + ": Maximum count on queue threshold (" + maximumMessageCount + ") breached.";
                NotificationCheck.logNotification((NotificationCheck)this, queue, notificationMsg);
                listener.notifyClients(this, queue, notificationMsg);
                return true;
            }
            return false;
        }
    }
    ,
    MESSAGE_SIZE_ALERT(true){

        @Override
        public boolean notifyIfNecessary(ServerMessage<?> msg, AMQQueue queue, AMQQueue.NotificationListener listener) {
            long maximumMessageSize = queue.getMaximumMessageSize();
            if (maximumMessageSize != 0L) {
                long messageSize;
                long l = messageSize = msg == null ? 0L : msg.getSize();
                if (messageSize >= maximumMessageSize) {
                    String notificationMsg = messageSize + "b : Maximum message size threshold (" + maximumMessageSize + ") breached. [Message ID=" + msg.getMessageNumber() + "]";
                    NotificationCheck.logNotification((NotificationCheck)this, queue, notificationMsg);
                    listener.notifyClients(this, queue, notificationMsg);
                    return true;
                }
            }
            return false;
        }
    }
    ,
    QUEUE_DEPTH_ALERT{

        @Override
        public boolean notifyIfNecessary(ServerMessage<?> msg, AMQQueue queue, AMQQueue.NotificationListener listener) {
            long queueDepth;
            long maximumQueueDepth = queue.getMaximumQueueDepth();
            if (maximumQueueDepth != 0L && (queueDepth = queue.getQueueDepth()) >= maximumQueueDepth) {
                String notificationMsg = (queueDepth >> 10) + "Kb : Maximum queue depth threshold (" + (maximumQueueDepth >> 10) + "Kb) breached.";
                NotificationCheck.logNotification((NotificationCheck)this, queue, notificationMsg);
                listener.notifyClients(this, queue, notificationMsg);
                return true;
            }
            return false;
        }
    }
    ,
    MESSAGE_AGE_ALERT{

        @Override
        public boolean notifyIfNecessary(ServerMessage<?> msg, AMQQueue queue, AMQQueue.NotificationListener listener) {
            long maxMessageAge = queue.getMaximumMessageAge();
            if (maxMessageAge != 0L) {
                long currentTime = System.currentTimeMillis();
                long thresholdTime = currentTime - maxMessageAge;
                long firstArrivalTime = queue.getOldestMessageArrivalTime();
                if (firstArrivalTime < thresholdTime) {
                    long oldestAge = currentTime - firstArrivalTime;
                    String notificationMsg = oldestAge / 1000L + "s : Maximum age on queue threshold (" + maxMessageAge / 1000L + "s) breached.";
                    NotificationCheck.logNotification((NotificationCheck)this, queue, notificationMsg);
                    listener.notifyClients(this, queue, notificationMsg);
                    return true;
                }
            }
            return false;
        }
    };

    private static final Logger LOGGER;
    private final boolean _messageSpecific;

    private NotificationCheck() {
        this(false);
    }

    private NotificationCheck(boolean messageSpecific) {
        this._messageSpecific = messageSpecific;
    }

    public boolean isMessageSpecific() {
        return this._messageSpecific;
    }

    public abstract boolean notifyIfNecessary(ServerMessage<?> var1, AMQQueue var2, AMQQueue.NotificationListener var3);

    private static void logNotification(NotificationCheck notification, AMQQueue queue, String notificationMsg) {
        LOGGER.info((Object)(notification.name() + " On Queue " + queue.getNameShortString() + " - " + notificationMsg));
    }

    static {
        LOGGER = Logger.getLogger(NotificationCheck.class);
    }
}

