/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.queue;

import java.util.Map;
import java.util.UUID;
import org.apache.qpid.AMQException;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.queue.BaseQueue;
import org.apache.qpid.server.queue.OutOfOrderQueue;
import org.apache.qpid.server.queue.QueueEntryListFactory;
import org.apache.qpid.server.queue.SortedQueueEntryListFactory;
import org.apache.qpid.server.virtualhost.VirtualHost;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortedQueue
extends OutOfOrderQueue {
    private final Object _sortedQueueLock = new Object();
    private final String _sortedPropertyName;

    protected SortedQueue(UUID id, String name, boolean durable, String owner, boolean autoDelete, boolean exclusive, VirtualHost virtualHost, Map<String, Object> arguments, String sortedPropertyName) {
        super(id, name, durable, owner, autoDelete, exclusive, virtualHost, (QueueEntryListFactory)new SortedQueueEntryListFactory(sortedPropertyName), arguments);
        this._sortedPropertyName = sortedPropertyName;
    }

    public String getSortedPropertyName() {
        return this._sortedPropertyName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enqueue(ServerMessage message, BaseQueue.PostEnqueueAction action) throws AMQException {
        Object object = this._sortedQueueLock;
        synchronized (object) {
            super.enqueue(message, action);
        }
    }
}

