/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.registry;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.qpid.common.QpidProperties;
import org.apache.qpid.server.configuration.BrokerConfig;
import org.apache.qpid.server.configuration.BrokerConfigType;
import org.apache.qpid.server.configuration.ConfigStore;
import org.apache.qpid.server.configuration.ConfiguredObject;
import org.apache.qpid.server.configuration.SystemConfig;
import org.apache.qpid.server.configuration.VirtualHostConfig;
import org.apache.qpid.server.registry.IApplicationRegistry;
import org.apache.qpid.server.virtualhost.VirtualHost;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrokerConfigAdapter
implements BrokerConfig {
    private final IApplicationRegistry _instance;
    private SystemConfig _system;
    private final Map<UUID, VirtualHostConfig> _vhosts = new ConcurrentHashMap<UUID, VirtualHostConfig>();
    private final long _createTime = System.currentTimeMillis();
    private UUID _qmfId;
    private String _federationTag;

    public BrokerConfigAdapter(IApplicationRegistry instance) {
        this._instance = instance;
        this._qmfId = instance.getConfigStore().createId();
        this._federationTag = UUID.randomUUID().toString();
    }

    @Override
    public void setSystem(SystemConfig system) {
        this._system = system;
    }

    @Override
    public SystemConfig getSystem() {
        return this._system;
    }

    @Override
    public Integer getPort() {
        List ports = this._instance.getConfiguration().getPorts();
        if (ports.size() > 0) {
            return Integer.valueOf(ports.get(0).toString());
        }
        return 0;
    }

    @Override
    public Integer getWorkerThreads() {
        return this._instance.getConfiguration().getConnectorProcessors();
    }

    @Override
    public Integer getMaxConnections() {
        return 0;
    }

    @Override
    public Integer getConnectionBacklogLimit() {
        return 0;
    }

    @Override
    public Long getStagingThreshold() {
        return 0L;
    }

    @Override
    public Integer getManagementPublishInterval() {
        return 10000;
    }

    @Override
    public String getVersion() {
        return QpidProperties.getReleaseVersion() + " [Build: " + QpidProperties.getBuildVersion() + "]";
    }

    @Override
    public String getDataDirectory() {
        return this._instance.getConfiguration().getQpidWork();
    }

    @Override
    public void addVirtualHost(VirtualHostConfig virtualHost) {
        this._vhosts.put(virtualHost.getQMFId(), virtualHost);
        this.getConfigStore().addConfiguredObject(virtualHost);
    }

    private ConfigStore getConfigStore() {
        return this._instance.getConfigStore();
    }

    @Override
    public long getCreateTime() {
        return this._createTime;
    }

    @Override
    public void createBrokerConnection(String transport, String host, int port, boolean durable, String authMechanism, String username, String password) {
        VirtualHost vhost = this._instance.getVirtualHostRegistry().getDefaultVirtualHost();
        vhost.createBrokerConnection(transport, host, port, "", durable, authMechanism, username, password);
    }

    @Override
    public UUID getQMFId() {
        return this._qmfId;
    }

    @Override
    public BrokerConfigType getConfigType() {
        return BrokerConfigType.getInstance();
    }

    @Override
    public ConfiguredObject getParent() {
        return this._system;
    }

    @Override
    public boolean isDurable() {
        return false;
    }

    @Override
    public String getFederationTag() {
        return this._federationTag;
    }

    @Override
    public List<String> getFeatures() {
        ArrayList<String> features = new ArrayList<String>();
        if (!this._instance.getConfiguration().getDisabledFeatures().contains("qpid.jms-selector")) {
            features.add("qpid.jms-selector");
        }
        return Collections.unmodifiableList(features);
    }

    public String toString() {
        return "BrokerConfigAdapter{_id=" + this._qmfId + ", _system=" + this._system + ", _vhosts=" + this._vhosts + ", _createTime=" + this._createTime + ", _federationTag='" + this._federationTag + '\'' + '}';
    }
}

