/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.auth.database;

import org.apache.qpid.server.security.auth.database.PasswordPrincipal;

public class PlainUser
implements PasswordPrincipal {
    private String _name;
    private char[] _password;
    private boolean _modified = false;
    private boolean _deleted = false;

    PlainUser(String[] data) {
        if (data.length != 2) {
            throw new IllegalArgumentException("User Data should be length 2, username, password");
        }
        this._name = data[0];
        this._password = data[1].toCharArray();
    }

    public PlainUser(String name, char[] password) {
        this._name = name;
        this._password = password;
        this._modified = true;
    }

    public String getName() {
        return this._name;
    }

    public String toString() {
        return this._name;
    }

    public char[] getPassword() {
        return this._password;
    }

    public byte[] getEncodedPassword() {
        byte[] byteArray = new byte[this._password.length];
        int index = 0;
        for (char c : this._password) {
            byteArray[index++] = (byte)c;
        }
        return byteArray;
    }

    public void restorePassword(char[] password) {
        this.setPassword(password);
    }

    public void setPassword(char[] password) {
        this._password = password;
        this._modified = true;
    }

    public boolean isModified() {
        return this._modified;
    }

    public boolean isDeleted() {
        return this._deleted;
    }

    public void delete() {
        this._deleted = true;
    }

    public void saved() {
        this._modified = false;
    }
}

