/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.auth.manager;

import java.io.IOException;
import java.security.Principal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.log4j.Logger;
import org.apache.qpid.server.configuration.plugins.ConfigurationPlugin;
import org.apache.qpid.server.configuration.plugins.ConfigurationPluginFactory;
import org.apache.qpid.server.security.auth.AuthenticationResult;
import org.apache.qpid.server.security.auth.manager.AuthenticationManager;
import org.apache.qpid.server.security.auth.manager.AuthenticationManagerPluginFactory;
import org.apache.qpid.server.security.auth.sasl.UsernamePrincipal;

public class KerberosAuthenticationManager
implements AuthenticationManager {
    private static final Logger _logger = Logger.getLogger(KerberosAuthenticationManager.class);
    private static final String GSSAPI_MECHANISM = "GSSAPI";
    private final CallbackHandler _callbackHandler = new GssApiCallbackHandler();
    public static final AuthenticationManagerPluginFactory<KerberosAuthenticationManager> FACTORY = new AuthenticationManagerPluginFactory<KerberosAuthenticationManager>(){

        @Override
        public KerberosAuthenticationManager newInstance(ConfigurationPlugin config) throws ConfigurationException {
            KerberosAuthenticationManagerConfiguration configuration;
            KerberosAuthenticationManagerConfiguration kerberosAuthenticationManagerConfiguration = configuration = config == null ? null : (KerberosAuthenticationManagerConfiguration)config.getConfiguration(KerberosAuthenticationManagerConfiguration.class.getName());
            if (configuration == null) {
                _logger.info((Object)"No authentication-manager configuration found for KerberosAuthenticationManager");
                return null;
            }
            KerberosAuthenticationManager kerberosAuthenticationManager = new KerberosAuthenticationManager();
            kerberosAuthenticationManager.configure(configuration);
            return kerberosAuthenticationManager;
        }

        @Override
        public Class<KerberosAuthenticationManager> getPluginClass() {
            return KerberosAuthenticationManager.class;
        }

        @Override
        public String getPluginName() {
            return KerberosAuthenticationManager.class.getName();
        }
    };

    private KerberosAuthenticationManager() {
    }

    public void initialise() {
    }

    public String getMechanisms() {
        return GSSAPI_MECHANISM;
    }

    public SaslServer createSaslServer(String mechanism, String localFQDN, Principal externalPrincipal) throws SaslException {
        if (GSSAPI_MECHANISM.equals(mechanism)) {
            try {
                return Sasl.createSaslServer(GSSAPI_MECHANISM, "AMQP", localFQDN, new HashMap(), this._callbackHandler);
            }
            catch (SaslException e) {
                e.printStackTrace(System.err);
                throw e;
            }
        }
        throw new SaslException("Unknown mechanism: " + mechanism);
    }

    public AuthenticationResult authenticate(SaslServer server, byte[] response) {
        try {
            byte[] challenge = server.evaluateResponse(response != null ? response : new byte[]{});
            if (server.isComplete()) {
                Subject subject = new Subject();
                _logger.debug((Object)("Authenticated as " + server.getAuthorizationID()));
                subject.getPrincipals().add(new UsernamePrincipal(server.getAuthorizationID()));
                return new AuthenticationResult(subject);
            }
            return new AuthenticationResult(challenge, AuthenticationResult.AuthenticationStatus.CONTINUE);
        }
        catch (SaslException e) {
            e.printStackTrace(System.err);
            return new AuthenticationResult(AuthenticationResult.AuthenticationStatus.ERROR, e);
        }
    }

    public AuthenticationResult authenticate(String username, String password) {
        return new AuthenticationResult(AuthenticationResult.AuthenticationStatus.ERROR);
    }

    public void close() {
    }

    public void configure(ConfigurationPlugin config) throws ConfigurationException {
    }

    private static class GssApiCallbackHandler
    implements CallbackHandler {
        private GssApiCallbackHandler() {
        }

        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (Callback callback : callbacks) {
                if (!(callback instanceof AuthorizeCallback)) {
                    throw new UnsupportedCallbackException(callback);
                }
                ((AuthorizeCallback)callback).setAuthorized(true);
            }
        }
    }

    public static class KerberosAuthenticationManagerConfiguration
    extends ConfigurationPlugin {
        public static final ConfigurationPluginFactory FACTORY = new ConfigurationPluginFactory(){

            @Override
            public List<String> getParentPaths() {
                return Arrays.asList("security.kerberos-auth-manager");
            }

            @Override
            public ConfigurationPlugin newInstance(String path, Configuration config) throws ConfigurationException {
                KerberosAuthenticationManagerConfiguration instance = new KerberosAuthenticationManagerConfiguration();
                instance.setConfiguration(path, config);
                return instance;
            }
        };

        public String[] getElementsProcessed() {
            return new String[0];
        }

        public void validateConfiguration() throws ConfigurationException {
        }
    }
}

