/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.auth.manager;

import java.io.IOException;
import java.security.Principal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.log4j.Logger;
import org.apache.qpid.server.configuration.plugins.ConfigurationPlugin;
import org.apache.qpid.server.configuration.plugins.ConfigurationPluginFactory;
import org.apache.qpid.server.security.auth.AuthenticationResult;
import org.apache.qpid.server.security.auth.manager.AuthenticationManager;
import org.apache.qpid.server.security.auth.manager.AuthenticationManagerPluginFactory;
import org.apache.qpid.server.security.auth.sasl.UsernamePrincipal;
import org.apache.qpid.server.security.auth.sasl.plain.PlainPasswordCallback;

public class SimpleLDAPAuthenticationManager
implements AuthenticationManager {
    private static final Logger _logger = Logger.getLogger(SimpleLDAPAuthenticationManager.class);
    private static final String PLAIN_MECHANISM = "PLAIN";
    private static final String DEFAULT_LDAP_CONTEXT_FACTORY = "com.sun.jndi.ldap.LdapCtxFactory";
    private String _providerSearchURL;
    private String _searchContext;
    private String _searchFilter;
    private String _providerAuthURL;
    private String _ldapContextFactory;
    public static final AuthenticationManagerPluginFactory<SimpleLDAPAuthenticationManager> FACTORY = new AuthenticationManagerPluginFactory<SimpleLDAPAuthenticationManager>(){

        @Override
        public SimpleLDAPAuthenticationManager newInstance(ConfigurationPlugin config) throws ConfigurationException {
            SimpleLDAPAuthenticationManagerConfiguration configuration;
            SimpleLDAPAuthenticationManagerConfiguration simpleLDAPAuthenticationManagerConfiguration = configuration = config == null ? null : (SimpleLDAPAuthenticationManagerConfiguration)config.getConfiguration(SimpleLDAPAuthenticationManagerConfiguration.class.getName());
            if (configuration == null) {
                _logger.info((Object)"No authentication-manager configuration found for SimpleLDAPAuthenticationManager");
                return null;
            }
            SimpleLDAPAuthenticationManager simpleLDAPAuthenticationManager = new SimpleLDAPAuthenticationManager();
            simpleLDAPAuthenticationManager.configure(configuration);
            return simpleLDAPAuthenticationManager;
        }

        @Override
        public Class<SimpleLDAPAuthenticationManager> getPluginClass() {
            return SimpleLDAPAuthenticationManager.class;
        }

        @Override
        public String getPluginName() {
            return SimpleLDAPAuthenticationManager.class.getName();
        }
    };

    private SimpleLDAPAuthenticationManager() {
    }

    public void initialise() {
    }

    public String getMechanisms() {
        return PLAIN_MECHANISM;
    }

    public SaslServer createSaslServer(String mechanism, String localFQDN, Principal externalPrincipal) throws SaslException {
        if (PLAIN_MECHANISM.equals(mechanism)) {
            return Sasl.createSaslServer(PLAIN_MECHANISM, "AMQP", localFQDN, new HashMap(), new PlainCallbackHandler());
        }
        throw new SaslException("Unknown mechanism: " + mechanism);
    }

    public AuthenticationResult authenticate(SaslServer server, byte[] response) {
        try {
            byte[] challenge = server.evaluateResponse(response != null ? response : new byte[]{});
            if (server.isComplete()) {
                Subject subject = new Subject();
                _logger.debug((Object)("Authenticated as " + server.getAuthorizationID()));
                subject.getPrincipals().add(new UsernamePrincipal(server.getAuthorizationID()));
                return new AuthenticationResult(subject);
            }
            return new AuthenticationResult(challenge, AuthenticationResult.AuthenticationStatus.CONTINUE);
        }
        catch (SaslException e) {
            return new AuthenticationResult(AuthenticationResult.AuthenticationStatus.ERROR, e);
        }
    }

    public AuthenticationResult authenticate(String username, String password) {
        try {
            return this.doLDAPNameAuthentication(this.getNameFromId(username), password);
        }
        catch (NamingException e) {
            return new AuthenticationResult(AuthenticationResult.AuthenticationStatus.ERROR, e);
        }
    }

    private AuthenticationResult doLDAPNameAuthentication(String username, String password) throws NamingException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", this._ldapContextFactory);
        env.put("java.naming.provider.url", this._providerAuthURL);
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", username);
        env.put("java.naming.security.credentials", password);
        InitialDirContext ctx = new InitialDirContext(env);
        ctx.close();
        Subject subject = new Subject();
        subject.getPrincipals().add(new UsernamePrincipal(username));
        return new AuthenticationResult(subject);
    }

    public void close() {
    }

    public void configure(ConfigurationPlugin config) throws ConfigurationException {
        SimpleLDAPAuthenticationManagerConfiguration ldapConfig = (SimpleLDAPAuthenticationManagerConfiguration)config;
        this._ldapContextFactory = ldapConfig.getLDAPContextFactory();
        this._providerSearchURL = ldapConfig.getProviderSearchURL();
        this._providerAuthURL = ldapConfig.getProviderAuthURL();
        this._searchContext = ldapConfig.getSearchContext();
        this._searchFilter = ldapConfig.getSearchFilter();
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", this._ldapContextFactory);
        env.put("java.naming.provider.url", this._providerSearchURL);
        env.put("java.naming.security.authentication", "none");
        try {
            new InitialDirContext(env);
        }
        catch (NamingException e) {
            throw new ConfigurationException("Unable to establish anonymous connection to the ldap server at " + this._providerSearchURL, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getNameFromId(String id) throws NamingException {
        String string;
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", this._ldapContextFactory);
        env.put("java.naming.provider.url", this._providerSearchURL);
        env.put("java.naming.security.authentication", "none");
        InitialDirContext ctx = null;
        ctx = new InitialDirContext(env);
        try {
            SearchControls searchControls = new SearchControls();
            searchControls.setReturningAttributes(new String[0]);
            searchControls.setCountLimit(1L);
            searchControls.setSearchScope(2);
            NamingEnumeration<SearchResult> namingEnum = null;
            String name = null;
            namingEnum = ctx.search(this._searchContext, this._searchFilter, (Object[])new String[]{id}, searchControls);
            if (namingEnum.hasMore()) {
                SearchResult result = namingEnum.next();
                name = result.getNameInNamespace();
            }
            string = name;
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            ctx.close();
            throw throwable;
        }
        ctx.close();
        return string;
    }

    private class PlainCallbackHandler
    implements CallbackHandler {
        private PlainCallbackHandler() {
        }

        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            String name = null;
            String password = null;
            AuthenticationResult authenticated = null;
            for (Callback callback : callbacks) {
                if (callback instanceof NameCallback) {
                    String id = ((NameCallback)callback).getDefaultName();
                    try {
                        name = SimpleLDAPAuthenticationManager.this.getNameFromId(id);
                    }
                    catch (NamingException e) {
                        _logger.info((Object)"SASL Authentication Error", (Throwable)e);
                    }
                    if (password == null) continue;
                    try {
                        authenticated = SimpleLDAPAuthenticationManager.this.doLDAPNameAuthentication(name, password);
                    }
                    catch (NamingException e) {
                        authenticated = new AuthenticationResult(AuthenticationResult.AuthenticationStatus.ERROR, e);
                    }
                    continue;
                }
                if (callback instanceof PlainPasswordCallback) {
                    password = ((PlainPasswordCallback)callback).getPlainPassword();
                    if (name == null) continue;
                    try {
                        authenticated = SimpleLDAPAuthenticationManager.this.doLDAPNameAuthentication(name, password);
                        if (authenticated.getStatus() != AuthenticationResult.AuthenticationStatus.SUCCESS) continue;
                        ((PlainPasswordCallback)callback).setAuthenticated(true);
                    }
                    catch (NamingException e) {
                        authenticated = new AuthenticationResult(AuthenticationResult.AuthenticationStatus.ERROR, e);
                    }
                    continue;
                }
                if (callback instanceof AuthorizeCallback) {
                    ((AuthorizeCallback)callback).setAuthorized(authenticated != null && authenticated.getStatus() == AuthenticationResult.AuthenticationStatus.SUCCESS);
                    continue;
                }
                throw new UnsupportedCallbackException(callback);
            }
        }
    }

    public static class SimpleLDAPAuthenticationManagerConfiguration
    extends ConfigurationPlugin {
        public static final ConfigurationPluginFactory FACTORY = new ConfigurationPluginFactory(){

            @Override
            public List<String> getParentPaths() {
                return Arrays.asList("security.simple-ldap-auth-manager");
            }

            @Override
            public ConfigurationPlugin newInstance(String path, Configuration config) throws ConfigurationException {
                SimpleLDAPAuthenticationManagerConfiguration instance = new SimpleLDAPAuthenticationManagerConfiguration();
                instance.setConfiguration(path, config);
                return instance;
            }
        };
        private static final String PROVIDER_URL = "provider-url";
        private static final String PROVIDER_SEARCH_URL = "provider-search-url";
        private static final String PROVIDER_AUTH_URL = "provider-auth-url";
        private static final String SEARCH_CONTEXT = "search-context";
        private static final String SEARCH_FILTER = "search-filter";
        private static final String LDAP_CONTEXT_FACTORY = "ldap-context-factory";

        public String[] getElementsProcessed() {
            return new String[]{PROVIDER_URL, PROVIDER_SEARCH_URL, PROVIDER_AUTH_URL, SEARCH_CONTEXT, SEARCH_FILTER, LDAP_CONTEXT_FACTORY};
        }

        public void validateConfiguration() throws ConfigurationException {
        }

        public String getLDAPContextFactory() {
            return this.getConfig().getString(LDAP_CONTEXT_FACTORY, SimpleLDAPAuthenticationManager.DEFAULT_LDAP_CONTEXT_FACTORY);
        }

        public String getProviderURL() {
            return this.getConfig().getString(PROVIDER_URL);
        }

        public String getProviderSearchURL() {
            return this.getConfig().getString(PROVIDER_SEARCH_URL, this.getProviderURL());
        }

        public String getSearchContext() {
            return this.getConfig().getString(SEARCH_CONTEXT);
        }

        public String getSearchFilter() {
            return this.getConfig().getString(SEARCH_FILTER);
        }

        public String getProviderAuthURL() {
            return this.getConfig().getString(PROVIDER_AUTH_URL, this.getProviderURL());
        }
    }
}

