/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.signal;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.log4j.Logger;

public abstract class SignalHandlerTask {
    private static final Logger LOGGER = Logger.getLogger(SignalHandlerTask.class);
    private static final String HANDLE_METHOD = "handle";
    private static final String SUN_MISC_SIGNAL_CLASS = "sun.misc.Signal";
    private static final String SUN_MISC_SIGNAL_HANDLER_CLASS = "sun.misc.SignalHandler";

    public boolean register(String signalName) {
        try {
            Class<?> signalClazz = Class.forName(SUN_MISC_SIGNAL_CLASS);
            Class<?> handlerClazz = Class.forName(SUN_MISC_SIGNAL_HANDLER_CLASS);
            InvocationHandler invoker = new InvocationHandler(){

                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    SignalHandlerTask.this.handle();
                    return null;
                }
            };
            Object handler = Proxy.newProxyInstance(handlerClazz.getClassLoader(), new Class[]{handlerClazz}, invoker);
            Constructor<?> signalConstructor = signalClazz.getConstructor(String.class);
            Object signal = signalConstructor.newInstance(signalName);
            Method handleMethod = signalClazz.getMethod(HANDLE_METHOD, signalClazz, handlerClazz);
            handleMethod.invoke(null, signal, handler);
        }
        catch (Exception e) {
            LOGGER.debug((Object)("Unable to register handler for Signal " + signalName + " due to exception: " + e), (Throwable)e);
            return false;
        }
        return true;
    }

    public abstract void handle();

    public static String getPlatformDescription() {
        String name = System.getProperty("os.name");
        String osVer = System.getProperty("os.version");
        String jvmVendor = System.getProperty("java.vm.vendor");
        String jvmName = System.getProperty("java.vm.name");
        String javaRuntimeVer = System.getProperty("java.runtime.version");
        return "OS: " + name + " " + osVer + ", JVM:" + jvmVendor + " " + jvmName + " " + javaRuntimeVer;
    }
}

