/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.configuration.Configuration;
import org.apache.qpid.AMQStoreException;
import org.apache.qpid.server.message.EnqueableMessage;
import org.apache.qpid.server.store.ConfigurationRecoveryHandler;
import org.apache.qpid.server.store.Event;
import org.apache.qpid.server.store.EventListener;
import org.apache.qpid.server.store.EventManager;
import org.apache.qpid.server.store.MessageStoreRecoveryHandler;
import org.apache.qpid.server.store.NullMessageStore;
import org.apache.qpid.server.store.State;
import org.apache.qpid.server.store.StateManager;
import org.apache.qpid.server.store.StorableMessageMetaData;
import org.apache.qpid.server.store.StoreFuture;
import org.apache.qpid.server.store.StoredMemoryMessage;
import org.apache.qpid.server.store.StoredMessage;
import org.apache.qpid.server.store.Transaction;
import org.apache.qpid.server.store.TransactionLogRecoveryHandler;
import org.apache.qpid.server.store.TransactionLogResource;

public class MemoryMessageStore
extends NullMessageStore {
    private final AtomicLong _messageId = new AtomicLong(1L);
    private final AtomicBoolean _closed = new AtomicBoolean(false);
    private static final Transaction IN_MEMORY_TRANSACTION = new Transaction(){

        public StoreFuture commitTranAsync() throws AMQStoreException {
            return StoreFuture.IMMEDIATE_FUTURE;
        }

        public void enqueueMessage(TransactionLogResource queue, EnqueableMessage message) throws AMQStoreException {
        }

        public void dequeueMessage(TransactionLogResource queue, EnqueableMessage message) throws AMQStoreException {
        }

        public void commitTran() throws AMQStoreException {
        }

        public void abortTran() throws AMQStoreException {
        }

        public void removeXid(long format, byte[] globalId, byte[] branchId) {
        }

        public void recordXid(long format, byte[] globalId, byte[] branchId, Transaction.Record[] enqueues, Transaction.Record[] dequeues) {
        }
    };
    private final StateManager _stateManager;
    private final EventManager _eventManager = new EventManager();

    public MemoryMessageStore() {
        this._stateManager = new StateManager(this._eventManager);
    }

    public void configureConfigStore(String name, ConfigurationRecoveryHandler recoveryHandler, Configuration config) throws Exception {
        this._stateManager.attainState(State.INITIALISING);
    }

    public void configureMessageStore(String name, MessageStoreRecoveryHandler recoveryHandler, TransactionLogRecoveryHandler tlogRecoveryHandler, Configuration config) throws Exception {
        this._stateManager.attainState(State.INITIALISED);
    }

    public void activate() throws Exception {
        this._stateManager.attainState(State.ACTIVATING);
        this._stateManager.attainState(State.ACTIVE);
    }

    public StoredMessage addMessage(StorableMessageMetaData metaData) {
        long id = this._messageId.getAndIncrement();
        StoredMemoryMessage message = new StoredMemoryMessage(id, metaData);
        return message;
    }

    public Transaction newTransaction() {
        return IN_MEMORY_TRANSACTION;
    }

    public boolean isPersistent() {
        return false;
    }

    public void close() throws Exception {
        this._stateManager.attainState(State.CLOSING);
        this._closed.getAndSet(true);
        this._stateManager.attainState(State.CLOSED);
    }

    public void addEventListener(EventListener eventListener, Event ... events) {
        this._eventManager.addEventListener(eventListener, events);
    }

    public String getStoreType() {
        return "Memory";
    }
}

