/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.virtualhost;

import org.apache.log4j.Logger;
import org.apache.qpid.server.logging.RootMessageLogger;
import org.apache.qpid.server.logging.actors.AbstractActor;
import org.apache.qpid.server.logging.actors.CurrentActor;
import org.apache.qpid.server.virtualhost.VirtualHost;

public abstract class HouseKeepingTask
implements Runnable {
    private Logger _logger = Logger.getLogger(this.getClass());
    private VirtualHost _virtualHost;
    private String _name;
    private RootMessageLogger _rootLogger;

    public HouseKeepingTask(VirtualHost vhost) {
        this._virtualHost = vhost;
        this._name = this._virtualHost.getName() + ":" + this.getClass().getSimpleName();
        this._rootLogger = CurrentActor.get().getRootMessageLogger();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run() {
        String originalThreadName = Thread.currentThread().getName();
        Thread.currentThread().setName(this._name);
        CurrentActor.set(new AbstractActor(this._rootLogger){

            public String getLogMessage() {
                return HouseKeepingTask.this._name;
            }
        });
        try {
            this.execute();
        }
        catch (Exception e) {
            this._logger.warn((Object)(this.getClass().getSimpleName() + " throw exception: " + e), (Throwable)e);
        }
        finally {
            CurrentActor.remove();
            Thread.currentThread().setName(originalThreadName);
        }
    }

    public VirtualHost getVirtualHost() {
        return this._virtualHost;
    }

    public abstract void execute();
}

