/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client.protocol;

import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.jms.JMSException;
import javax.security.sasl.SaslClient;
import org.apache.qpid.AMQException;
import org.apache.qpid.client.AMQConnection;
import org.apache.qpid.client.AMQSession;
import org.apache.qpid.client.ConnectionTuneParameters;
import org.apache.qpid.client.handler.ClientMethodDispatcherImpl;
import org.apache.qpid.client.message.UnprocessedMessage;
import org.apache.qpid.client.message.UnprocessedMessage_0_8;
import org.apache.qpid.client.protocol.AMQProtocolHandler;
import org.apache.qpid.client.state.AMQStateManager;
import org.apache.qpid.framing.AMQBody;
import org.apache.qpid.framing.AMQDataBlock;
import org.apache.qpid.framing.AMQMethodBody;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.ContentBody;
import org.apache.qpid.framing.ContentHeaderBody;
import org.apache.qpid.framing.FieldTable;
import org.apache.qpid.framing.HeartbeatBody;
import org.apache.qpid.framing.MethodDispatcher;
import org.apache.qpid.framing.MethodRegistry;
import org.apache.qpid.framing.ProtocolInitiation;
import org.apache.qpid.framing.ProtocolVersion;
import org.apache.qpid.protocol.AMQConstant;
import org.apache.qpid.protocol.AMQVersionAwareProtocolSession;
import org.apache.qpid.transport.ConnectionSettings;
import org.apache.qpid.transport.Sender;
import org.apache.qpid.transport.TransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQProtocolSession
implements AMQVersionAwareProtocolSession {
    protected static final int LAST_WRITE_FUTURE_JOIN_TIMEOUT = 120000;
    protected static final Logger _logger = LoggerFactory.getLogger(AMQProtocolSession.class);
    public static final int MAX_CHANNEL_MAX = 65535;
    public static final int MIN_USABLE_CHANNEL_NUM = 1;
    private final AMQProtocolHandler _protocolHandler;
    private ConcurrentMap<Integer, AMQSession> _channelId2SessionMap = new ConcurrentHashMap<Integer, AMQSession>();
    private ConcurrentMap _closingChannels = new ConcurrentHashMap();
    private final ConcurrentMap<Integer, UnprocessedMessage> _channelId2UnprocessedMsgMap = new ConcurrentHashMap<Integer, UnprocessedMessage>();
    private final UnprocessedMessage[] _channelId2UnprocessedMsgArray = new UnprocessedMessage[16];
    private int _queueId = 1;
    private final Object _queueIdLock = new Object();
    private ProtocolVersion _protocolVersion;
    private MethodRegistry _methodRegistry = MethodRegistry.getMethodRegistry((ProtocolVersion)ProtocolVersion.getLatestSupportedVersion());
    private MethodDispatcher _methodDispatcher;
    private final AMQConnection _connection;
    private ConnectionTuneParameters _connectionTuneParameters;
    private FieldTable _connectionStartServerProperties;
    private SaslClient _saslClient;
    private static final int FAST_CHANNEL_ACCESS_MASK = -16;

    public AMQProtocolSession(AMQProtocolHandler protocolHandler, AMQConnection connection) {
        this._protocolHandler = protocolHandler;
        this._protocolVersion = connection.getProtocolVersion();
        if (_logger.isDebugEnabled()) {
            _logger.debug("Using ProtocolVersion for Session:" + this._protocolVersion);
        }
        this._methodDispatcher = ClientMethodDispatcherImpl.newMethodDispatcher(ProtocolVersion.getLatestSupportedVersion(), this);
        this._connection = connection;
    }

    public void init(ConnectionSettings settings) {
        this.initialiseTuneParameters(settings);
        this._protocolHandler.writeFrame((AMQDataBlock)new ProtocolInitiation(this._connection.getProtocolVersion()));
    }

    public ConnectionTuneParameters getConnectionTuneParameters() {
        return this._connectionTuneParameters;
    }

    private void initialiseTuneParameters(ConnectionSettings settings) {
        this._connectionTuneParameters = new ConnectionTuneParameters();
        this._connectionTuneParameters.setHeartbeat(settings.getHeartbeatInterval08());
        this._connectionTuneParameters.setHeartbeatTimeoutFactor(settings.getHeartbeatTimeoutFactor());
    }

    public void tuneConnection(ConnectionTuneParameters params) {
        this._connectionTuneParameters = params;
        AMQConnection con = this.getAMQConnection();
        con.setMaximumChannelCount(params.getChannelMax());
        con.setMaximumFrameSize(params.getFrameMax());
        this._protocolHandler.initHeartbeats(params.getHeartbeat(), params.getHeartbeatTimeoutFactor());
    }

    public String getClientID() {
        try {
            return this.getAMQConnection().getClientID();
        }
        catch (JMSException e) {
            return null;
        }
    }

    public void setClientID(String clientID) throws JMSException {
        this.getAMQConnection().setClientID(clientID);
    }

    public AMQStateManager getStateManager() {
        return this._protocolHandler.getStateManager();
    }

    public String getVirtualHost() {
        return this.getAMQConnection().getVirtualHost();
    }

    public SaslClient getSaslClient() {
        return this._saslClient;
    }

    public void setSaslClient(SaslClient client) {
        this._saslClient = client;
    }

    public void unprocessedMessageReceived(int channelId, UnprocessedMessage message) throws AMQException {
        if ((channelId & 0xFFFFFFF0) == 0) {
            this._channelId2UnprocessedMsgArray[channelId] = message;
        } else {
            this._channelId2UnprocessedMsgMap.put(channelId, message);
        }
    }

    public void contentHeaderReceived(int channelId, ContentHeaderBody contentHeader) throws AMQException {
        UnprocessedMessage_0_8 msg = (UnprocessedMessage_0_8)((channelId & 0xFFFFFFF0) == 0 ? this._channelId2UnprocessedMsgArray[channelId] : (UnprocessedMessage)this._channelId2UnprocessedMsgMap.get(channelId));
        if (msg == null) {
            throw new AMQException(null, "Error: received content header without having received a BasicDeliver frame first on session:" + this, null);
        }
        if (msg.getContentHeader() != null) {
            throw new AMQException(null, "Error: received duplicate content header or did not receive correct number of content body frames on session:" + this, null);
        }
        msg.setContentHeader(contentHeader);
        if (contentHeader.getBodySize() == 0L) {
            this.deliverMessageToAMQSession(channelId, msg);
        }
    }

    public void contentBodyReceived(int channelId, ContentBody contentBody) throws AMQException {
        boolean fastAccess = (channelId & 0xFFFFFFF0) == 0;
        UnprocessedMessage_0_8 msg = fastAccess ? (UnprocessedMessage_0_8)this._channelId2UnprocessedMsgArray[channelId] : (UnprocessedMessage_0_8)this._channelId2UnprocessedMsgMap.get(channelId);
        if (msg == null) {
            throw new AMQException(null, "Error: received content body without having received a JMSDeliver frame first", null);
        }
        if (msg.getContentHeader() == null) {
            if (fastAccess) {
                this._channelId2UnprocessedMsgArray[channelId] = null;
            } else {
                this._channelId2UnprocessedMsgMap.remove(channelId);
            }
            throw new AMQException(null, "Error: received content body without having received a ContentHeader frame first", null);
        }
        msg.receiveBody(contentBody);
        if (msg.isAllBodyDataReceived()) {
            this.deliverMessageToAMQSession(channelId, msg);
        }
    }

    public void heartbeatBodyReceived(int channelId, HeartbeatBody body) throws AMQException {
        this._protocolHandler.heartbeatBodyReceived();
    }

    private void deliverMessageToAMQSession(int channelId, UnprocessedMessage msg) {
        AMQSession session = this.getSession(channelId);
        session.messageReceived(msg);
        if ((channelId & 0xFFFFFFF0) == 0) {
            this._channelId2UnprocessedMsgArray[channelId] = null;
        } else {
            this._channelId2UnprocessedMsgMap.remove(channelId);
        }
    }

    protected AMQSession getSession(int channelId) {
        return this._connection.getSession(channelId);
    }

    public void writeFrame(AMQDataBlock frame) {
        this._protocolHandler.writeFrame(frame);
    }

    public void closeSession(AMQSession session) {
        int channelId;
        if (_logger.isDebugEnabled()) {
            _logger.debug("closeSession called on protocol session for session " + session.getChannelId());
        }
        if ((channelId = session.getChannelId()) <= 0) {
            throw new IllegalArgumentException("Attempt to close a channel with id < 0");
        }
        this._closingChannels.putIfAbsent(channelId, session);
    }

    public boolean channelClosed(int channelId, AMQConstant code, String text) throws AMQException {
        if (this._closingChannels.remove(channelId) == null) {
            AMQSession session = this.getSession(channelId);
            try {
                session.closed(new AMQException(code, text, null));
            }
            catch (JMSException e) {
                throw new AMQException(null, "JMSException received while closing session", (Throwable)e);
            }
            return true;
        }
        return false;
    }

    public AMQConnection getAMQConnection() {
        return this._connection;
    }

    public void closeProtocolSession() throws AMQException {
        try {
            this._protocolHandler.getNetworkConnection().close();
        }
        catch (TransportException transportException) {
            // empty catch block
        }
    }

    public Sender<ByteBuffer> getSender() {
        return this._protocolHandler.getSender();
    }

    public void failover(String host, int port) {
        this._protocolHandler.failover(host, port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AMQShortString generateQueueName() {
        int id;
        Object object = this._queueIdLock;
        synchronized (object) {
            id = this._queueId++;
        }
        String localAddress = this._protocolHandler.getLocalAddress().toString().replaceAll("[./:;]", "_");
        String queueName = "tmp_" + localAddress + "_" + id;
        return new AMQShortString(queueName.replaceAll("_+", "_"));
    }

    public void confirmConsumerCancelled(int channelId, AMQShortString consumerTag) {
        AMQSession session = this.getSession(channelId);
        session.confirmConsumerCancelled(consumerTag.toIntValue());
    }

    public void setProtocolVersion(ProtocolVersion pv) {
        if (_logger.isDebugEnabled()) {
            _logger.debug("Setting ProtocolVersion to :" + pv);
        }
        this._protocolVersion = pv;
        this._methodRegistry = MethodRegistry.getMethodRegistry((ProtocolVersion)pv);
        this._methodDispatcher = ClientMethodDispatcherImpl.newMethodDispatcher(pv, this);
    }

    public byte getProtocolMinorVersion() {
        return this._protocolVersion.getMinorVersion();
    }

    public byte getProtocolMajorVersion() {
        return this._protocolVersion.getMajorVersion();
    }

    public ProtocolVersion getProtocolVersion() {
        return this._protocolVersion;
    }

    public MethodRegistry getMethodRegistry() {
        return this._methodRegistry;
    }

    public MethodDispatcher getMethodDispatcher() {
        return this._methodDispatcher;
    }

    public void setTicket(int ticket, int channelId) {
        AMQSession session = this.getSession(channelId);
        session.setTicket(ticket);
    }

    public void setMethodDispatcher(MethodDispatcher methodDispatcher) {
        this._methodDispatcher = methodDispatcher;
    }

    public void setFlowControl(int channelId, boolean active) {
        AMQSession session = this.getSession(channelId);
        session.setFlowControl(active);
    }

    public void methodFrameReceived(int channel, AMQMethodBody amqMethodBody) throws AMQException {
        this._protocolHandler.methodBodyReceived(channel, (AMQBody)amqMethodBody);
    }

    public void notifyError(Exception error) {
        this._protocolHandler.propagateExceptionToAllWaiters(error);
    }

    public void setSender(Sender<ByteBuffer> sender) {
    }

    public String toString() {
        return "AMQProtocolSession[" + this._connection + ']';
    }

    protected AMQProtocolHandler getProtocolHandler() {
        return this._protocolHandler;
    }

    protected ConcurrentMap<Integer, AMQSession> getChannelId2SessionMap() {
        return this._channelId2SessionMap;
    }

    protected void setChannelId2SessionMap(ConcurrentMap<Integer, AMQSession> channelId2SessionMap) {
        this._channelId2SessionMap = channelId2SessionMap;
    }

    protected ConcurrentMap getClosingChannels() {
        return this._closingChannels;
    }

    protected void setClosingChannels(ConcurrentMap closingChannels) {
        this._closingChannels = closingChannels;
    }

    protected int getQueueId() {
        return this._queueId;
    }

    protected void setQueueId(int queueId) {
        this._queueId = queueId;
    }

    protected Object getQueueIdLock() {
        return this._queueIdLock;
    }

    protected AMQConnection getConnection() {
        return this._connection;
    }

    public void setConnectionStartServerProperties(FieldTable serverProperties) {
        this._connectionStartServerProperties = serverProperties;
    }

    public FieldTable getConnectionStartServerProperties() {
        return this._connectionStartServerProperties;
    }
}

