/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client.security;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.apache.qpid.client.security.AMQCallbackHandler;
import org.apache.qpid.client.security.DynamicSaslRegistrar;
import org.apache.qpid.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CallbackHandlerRegistry {
    private static final Logger _logger = LoggerFactory.getLogger(CallbackHandlerRegistry.class);
    private static final String FILE_PROPERTY = "amq.callbackhandler.properties";
    public static final String DEFAULT_RESOURCE_NAME = "org/apache/qpid/client/security/CallbackHandlerRegistry.properties";
    private static final CallbackHandlerRegistry _instance;
    private Map<String, Class<AMQCallbackHandler>> _mechanismToHandlerClassMap = new HashMap<String, Class<AMQCallbackHandler>>();
    private Collection<String> _mechanisms;
    private static final Collection<String> MECHS_THAT_NEED_USERPASS;

    public static CallbackHandlerRegistry getInstance() {
        return _instance;
    }

    public AMQCallbackHandler createCallbackHandler(String mechanism) {
        Class<AMQCallbackHandler> mechanismClass = this._mechanismToHandlerClassMap.get(mechanism);
        if (mechanismClass == null) {
            throw new IllegalArgumentException("Mechanism " + mechanism + " not known");
        }
        try {
            return mechanismClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Unable to create an instance of mechanism " + mechanism, e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Unable to create an instance of mechanism " + mechanism, e);
        }
    }

    public Collection<String> getMechanisms() {
        return Collections.unmodifiableCollection(this._mechanisms);
    }

    CallbackHandlerRegistry(Properties props) {
        this.parseProperties(props);
    }

    private void parseProperties(Properties props) {
        TreeMap<Integer, String> mechanisms = new TreeMap<Integer, String>();
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String propertyName = (String)e.nextElement();
            String[] parts = propertyName.split("\\.", 2);
            this.checkPropertyNameFormat(propertyName, parts);
            String mechanism = parts[0];
            int ordinal = this.getPropertyOrdinal(propertyName, parts);
            String className = props.getProperty(propertyName);
            Class<?> clazz = null;
            try {
                clazz = Class.forName(className);
                if (!AMQCallbackHandler.class.isAssignableFrom(clazz)) {
                    _logger.warn("SASL provider " + clazz + " does not implement " + AMQCallbackHandler.class + ". Skipping");
                    continue;
                }
                this._mechanismToHandlerClassMap.put(mechanism, clazz);
                mechanisms.put(ordinal, mechanism);
            }
            catch (ClassNotFoundException ex) {
                _logger.warn("Unable to load class " + className + ". Skipping that SASL provider");
            }
        }
        this._mechanisms = mechanisms.values();
    }

    private void checkPropertyNameFormat(String propertyName, String[] parts) {
        if (parts.length != 2) {
            throw new IllegalArgumentException("Unable to parse property " + propertyName + " when configuring SASL providers");
        }
    }

    private int getPropertyOrdinal(String propertyName, String[] parts) {
        try {
            return Integer.parseInt(parts[1]);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Unable to parse property " + propertyName + " when configuring SASL providers", nfe);
        }
    }

    public String selectMechanism(String peerMechanismList) {
        Set<String> peerList = this.mechListToSet(peerMechanismList);
        return this.selectMechInternal(peerList, Collections.<String>emptySet());
    }

    public String selectMechanism(String peerMechanismList, String restrictionList) {
        Set<String> peerList = this.mechListToSet(peerMechanismList);
        Set<String> restrictionSet = this.mechListToSet(restrictionList);
        return this.selectMechInternal(peerList, restrictionSet);
    }

    private String selectMechInternal(Set<String> peerSet, Set<String> restrictionSet) {
        for (String mech : this._mechanisms) {
            if (!peerSet.contains(mech) || !restrictionSet.isEmpty() && !restrictionSet.contains(mech)) continue;
            return mech;
        }
        return null;
    }

    private Set<String> mechListToSet(String mechanismList) {
        if (mechanismList == null) {
            return Collections.emptySet();
        }
        StringTokenizer tokenizer = new StringTokenizer(mechanismList, " ");
        HashSet<String> mechanismSet = new HashSet<String>(tokenizer.countTokens());
        while (tokenizer.hasMoreTokens()) {
            mechanismSet.add(tokenizer.nextToken());
        }
        return Collections.unmodifiableSet(mechanismSet);
    }

    public boolean isUserPassRequired(String selectedMech) {
        return MECHS_THAT_NEED_USERPASS.contains(selectedMech);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        MECHS_THAT_NEED_USERPASS = Arrays.asList("PLAIN", "AMQPLAIN", "CRAM-MD5", "CRAM-MD5-HASHED");
        DynamicSaslRegistrar.registerSaslProviders();
        String filename = System.getProperty(FILE_PROPERTY);
        InputStream is = FileUtils.openFileOrDefaultResource((String)filename, (String)DEFAULT_RESOURCE_NAME, (ClassLoader)CallbackHandlerRegistry.class.getClassLoader());
        Properties props = new Properties();
        try {
            props.load(is);
        }
        catch (IOException e) {
            _logger.error("Error reading properties: " + e, (Throwable)e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    _logger.error("Unable to close properties stream: " + e, (Throwable)e);
                }
            }
        }
        _instance = new CallbackHandlerRegistry(props);
        _logger.info("Callback handlers available for SASL mechanisms: " + CallbackHandlerRegistry._instance._mechanisms);
    }
}

