/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.framing.amqp_0_9;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.qpid.AMQException;
import org.apache.qpid.codec.MarkableDataInput;
import org.apache.qpid.framing.AMQFrameDecodingException;
import org.apache.qpid.framing.AMQMethodBody;
import org.apache.qpid.framing.AMQMethodBodyInstanceFactory;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.ExchangeDeleteBody;
import org.apache.qpid.framing.MethodDispatcher;
import org.apache.qpid.framing.amqp_0_9.AMQMethodBody_0_9;
import org.apache.qpid.framing.amqp_0_9.MethodDispatcher_0_9;

public class ExchangeDeleteBodyImpl
extends AMQMethodBody_0_9
implements ExchangeDeleteBody {
    private static final AMQMethodBodyInstanceFactory FACTORY_INSTANCE = new AMQMethodBodyInstanceFactory(){

        public AMQMethodBody newInstance(MarkableDataInput in, long size) throws AMQFrameDecodingException, IOException {
            return new ExchangeDeleteBodyImpl(in);
        }
    };
    public static final int CLASS_ID = 40;
    public static final int METHOD_ID = 20;
    private final int _ticket;
    private final AMQShortString _exchange;
    private final byte _bitfield0;

    public static AMQMethodBodyInstanceFactory getFactory() {
        return FACTORY_INSTANCE;
    }

    public ExchangeDeleteBodyImpl(MarkableDataInput buffer) throws AMQFrameDecodingException, IOException {
        this._ticket = this.readUnsignedShort(buffer);
        this._exchange = this.readAMQShortString(buffer);
        this._bitfield0 = this.readBitfield(buffer);
    }

    public ExchangeDeleteBodyImpl(int ticket, AMQShortString exchange, boolean ifUnused, boolean nowait) {
        this._ticket = ticket;
        this._exchange = exchange;
        byte bitfield0 = 0;
        if (ifUnused) {
            bitfield0 = (byte)(bitfield0 | 1);
        }
        if (nowait) {
            bitfield0 = (byte)(bitfield0 | 2);
        }
        this._bitfield0 = bitfield0;
    }

    public int getClazz() {
        return 40;
    }

    public int getMethod() {
        return 20;
    }

    public final int getTicket() {
        return this._ticket;
    }

    public final AMQShortString getExchange() {
        return this._exchange;
    }

    public final boolean getIfUnused() {
        return (this._bitfield0 & 1) != 0;
    }

    public final boolean getNowait() {
        return (this._bitfield0 & 2) != 0;
    }

    protected int getBodySize() {
        int size = 3;
        return size += this.getSizeOf(this._exchange);
    }

    public void writeMethodPayload(DataOutput buffer) throws IOException {
        this.writeUnsignedShort(buffer, this._ticket);
        this.writeAMQShortString(buffer, this._exchange);
        this.writeBitfield(buffer, this._bitfield0);
    }

    public boolean execute(MethodDispatcher dispatcher, int channelId) throws AMQException {
        return ((MethodDispatcher_0_9)dispatcher).dispatchExchangeDelete(this, channelId);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("[ExchangeDeleteBodyImpl: ");
        buf.append("ticket=");
        buf.append(this.getTicket());
        buf.append(", ");
        buf.append("exchange=");
        buf.append(this.getExchange());
        buf.append(", ");
        buf.append("ifUnused=");
        buf.append(this.getIfUnused());
        buf.append(", ");
        buf.append("nowait=");
        buf.append(this.getNowait());
        buf.append("]");
        return buf.toString();
    }
}

