/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.transport;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.qpid.transport.ConnectionCloseCode;
import org.apache.qpid.transport.Method;
import org.apache.qpid.transport.MethodDelegate;
import org.apache.qpid.transport.Option;
import org.apache.qpid.transport.codec.Decoder;
import org.apache.qpid.transport.codec.Encoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConnectionClose
extends Method {
    public static final int TYPE = 267;
    private short packing_flags = 0;
    private ConnectionCloseCode replyCode;
    private String replyText;

    @Override
    public final int getStructType() {
        return 267;
    }

    @Override
    public final int getSizeWidth() {
        return 0;
    }

    @Override
    public final int getPackWidth() {
        return 2;
    }

    @Override
    public final boolean hasPayload() {
        return false;
    }

    @Override
    public final byte getEncodedTrack() {
        return 0;
    }

    @Override
    public final boolean isConnectionControl() {
        return true;
    }

    public ConnectionClose() {
    }

    public ConnectionClose(ConnectionCloseCode replyCode, String replyText, Option ... _options) {
        if (replyCode != null) {
            this.setReplyCode(replyCode);
        }
        if (replyText != null) {
            this.setReplyText(replyText);
        }
        block6: for (int i = 0; i < _options.length; ++i) {
            switch (_options[i]) {
                case SYNC: {
                    this.setSync(true);
                    continue block6;
                }
                case BATCH: {
                    this.setBatch(true);
                    continue block6;
                }
                case UNRELIABLE: {
                    this.setUnreliable(true);
                    continue block6;
                }
                case NONE: {
                    continue block6;
                }
                default: {
                    throw new IllegalArgumentException("invalid option: " + (Object)((Object)_options[i]));
                }
            }
        }
    }

    @Override
    public <C> void dispatch(C context, MethodDelegate<C> delegate) {
        delegate.connectionClose(context, this);
    }

    public final boolean hasReplyCode() {
        return (this.packing_flags & 0x100) != 0;
    }

    public final ConnectionClose clearReplyCode() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFFEFF);
        this.replyCode = null;
        this.setDirty(true);
        return this;
    }

    public final ConnectionCloseCode getReplyCode() {
        return this.replyCode;
    }

    public final ConnectionClose setReplyCode(ConnectionCloseCode value) {
        this.replyCode = value;
        this.packing_flags = (short)(this.packing_flags | 0x100);
        this.setDirty(true);
        return this;
    }

    public final ConnectionClose replyCode(ConnectionCloseCode value) {
        return this.setReplyCode(value);
    }

    public final boolean hasReplyText() {
        return (this.packing_flags & 0x200) != 0;
    }

    public final ConnectionClose clearReplyText() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFFDFF);
        this.replyText = null;
        this.setDirty(true);
        return this;
    }

    public final String getReplyText() {
        return this.replyText;
    }

    public final ConnectionClose setReplyText(String value) {
        this.replyText = value;
        this.packing_flags = (short)(this.packing_flags | 0x200);
        this.setDirty(true);
        return this;
    }

    public final ConnectionClose replyText(String value) {
        return this.setReplyText(value);
    }

    @Override
    public void write(Encoder enc) {
        enc.writeUint16(this.packing_flags);
        if ((this.packing_flags & 0x100) != 0) {
            enc.writeUint16(this.replyCode.getValue());
        }
        if ((this.packing_flags & 0x200) != 0) {
            enc.writeStr8(this.replyText);
        }
    }

    @Override
    public void read(Decoder dec) {
        this.packing_flags = (short)dec.readUint16();
        if ((this.packing_flags & 0x100) != 0) {
            this.replyCode = ConnectionCloseCode.get(dec.readUint16());
        }
        if ((this.packing_flags & 0x200) != 0) {
            this.replyText = dec.readStr8();
        }
    }

    @Override
    public Map<String, Object> getFields() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        if ((this.packing_flags & 0x100) != 0) {
            result.put("replyCode", (Object)this.getReplyCode());
        }
        if ((this.packing_flags & 0x200) != 0) {
            result.put("replyText", this.getReplyText());
        }
        return result;
    }
}

