/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.transport;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.qpid.transport.Method;
import org.apache.qpid.transport.MethodDelegate;
import org.apache.qpid.transport.Option;
import org.apache.qpid.transport.codec.Decoder;
import org.apache.qpid.transport.codec.Encoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SessionCommandPoint
extends Method {
    public static final int TYPE = 519;
    private short packing_flags = 0;
    private int commandId;
    private long commandOffset;

    @Override
    public final int getStructType() {
        return 519;
    }

    @Override
    public final int getSizeWidth() {
        return 0;
    }

    @Override
    public final int getPackWidth() {
        return 2;
    }

    @Override
    public final boolean hasPayload() {
        return false;
    }

    @Override
    public final byte getEncodedTrack() {
        return 2;
    }

    @Override
    public final boolean isConnectionControl() {
        return false;
    }

    public SessionCommandPoint() {
    }

    public SessionCommandPoint(int commandId, long commandOffset, Option ... _options) {
        this.setCommandId(commandId);
        this.setCommandOffset(commandOffset);
        block6: for (int i = 0; i < _options.length; ++i) {
            switch (_options[i]) {
                case SYNC: {
                    this.setSync(true);
                    continue block6;
                }
                case BATCH: {
                    this.setBatch(true);
                    continue block6;
                }
                case UNRELIABLE: {
                    this.setUnreliable(true);
                    continue block6;
                }
                case NONE: {
                    continue block6;
                }
                default: {
                    throw new IllegalArgumentException("invalid option: " + (Object)((Object)_options[i]));
                }
            }
        }
    }

    @Override
    public <C> void dispatch(C context, MethodDelegate<C> delegate) {
        delegate.sessionCommandPoint(context, this);
    }

    public final boolean hasCommandId() {
        return (this.packing_flags & 0x100) != 0;
    }

    public final SessionCommandPoint clearCommandId() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFFEFF);
        this.commandId = 0;
        this.setDirty(true);
        return this;
    }

    public final int getCommandId() {
        return this.commandId;
    }

    public final SessionCommandPoint setCommandId(int value) {
        this.commandId = value;
        this.packing_flags = (short)(this.packing_flags | 0x100);
        this.setDirty(true);
        return this;
    }

    public final SessionCommandPoint commandId(int value) {
        return this.setCommandId(value);
    }

    public final boolean hasCommandOffset() {
        return (this.packing_flags & 0x200) != 0;
    }

    public final SessionCommandPoint clearCommandOffset() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFFDFF);
        this.commandOffset = 0L;
        this.setDirty(true);
        return this;
    }

    public final long getCommandOffset() {
        return this.commandOffset;
    }

    public final SessionCommandPoint setCommandOffset(long value) {
        this.commandOffset = value;
        this.packing_flags = (short)(this.packing_flags | 0x200);
        this.setDirty(true);
        return this;
    }

    public final SessionCommandPoint commandOffset(long value) {
        return this.setCommandOffset(value);
    }

    @Override
    public void write(Encoder enc) {
        enc.writeUint16(this.packing_flags);
        if ((this.packing_flags & 0x100) != 0) {
            enc.writeSequenceNo(this.commandId);
        }
        if ((this.packing_flags & 0x200) != 0) {
            enc.writeUint64(this.commandOffset);
        }
    }

    @Override
    public void read(Decoder dec) {
        this.packing_flags = (short)dec.readUint16();
        if ((this.packing_flags & 0x100) != 0) {
            this.commandId = dec.readSequenceNo();
        }
        if ((this.packing_flags & 0x200) != 0) {
            this.commandOffset = dec.readUint64();
        }
    }

    @Override
    public Map<String, Object> getFields() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        if ((this.packing_flags & 0x100) != 0) {
            result.put("commandId", this.getCommandId());
        }
        if ((this.packing_flags & 0x200) != 0) {
            result.put("commandOffset", this.getCommandOffset());
        }
        return result;
    }
}

