/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.url;

import java.util.Map;
import org.apache.qpid.url.URLSyntaxException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URLHelper {
    public static final char DEFAULT_OPTION_SEPERATOR = '&';
    public static final char ALTERNATIVE_OPTION_SEPARATOR = ',';
    public static final char BROKER_SEPARATOR = ';';

    private URLHelper() {
    }

    public static void parseOptions(Map<String, String> optionMap, String options) throws URLSyntaxException {
        if (options == null || options.indexOf(61) == -1) {
            return;
        }
        int optionIndex = options.indexOf(61);
        String option = options.substring(0, optionIndex);
        int length = options.length();
        int nestedQuotes = 0;
        int valueIndex = optionIndex;
        while ((nestedQuotes > 0 || valueIndex < length) && ++valueIndex < length) {
            if (options.charAt(valueIndex) != '\'') continue;
            if (valueIndex + 1 < options.length()) {
                if (options.charAt(valueIndex + 1) == '&' || options.charAt(valueIndex + 1) == ',' || options.charAt(valueIndex + 1) == ';' || options.charAt(valueIndex + 1) == '\'') {
                    if (--nestedQuotes != 0) continue;
                    break;
                }
                ++nestedQuotes;
                continue;
            }
            if (options.charAt(valueIndex) != '\'') break;
            --nestedQuotes;
            break;
        }
        if (nestedQuotes != 0 || valueIndex < optionIndex + 2) {
            int sepIndex = 0;
            if (nestedQuotes > 1) {
                for (int i = 0; i < nestedQuotes; ++i) {
                    sepIndex = options.indexOf(39, sepIndex);
                    ++sepIndex;
                }
            }
            if (sepIndex >= options.length() || sepIndex == 0) {
                throw URLHelper.parseError(valueIndex, "Unterminated option", options);
            }
            throw URLHelper.parseError(sepIndex, "Unterminated option. Possible illegal option separator:'" + options.charAt(sepIndex) + "'", options);
        }
        String value = options.substring(optionIndex + 2, valueIndex);
        optionMap.put(option, value);
        if (valueIndex < options.length() - 1) {
            URLHelper.parseOptions(optionMap, options.substring(valueIndex + 2));
        }
    }

    public static URLSyntaxException parseError(int index, String error, String url) {
        return URLHelper.parseError(index, 1, error, url);
    }

    public static URLSyntaxException parseError(int index, int length, String error, String url) {
        return new URLSyntaxException(url, error, index, length);
    }

    public static String printOptions(Map<String, String> options) {
        if (options.isEmpty()) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        sb.append('?');
        for (String key : options.keySet()) {
            sb.append(key);
            sb.append("='");
            sb.append(options.get(key));
            sb.append("'");
            sb.append('&');
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }
}

