/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.framing;

import java.io.IOException;
import org.apache.qpid.codec.MarkableDataInput;
import org.apache.qpid.framing.AMQFrame;
import org.apache.qpid.framing.AMQFrameDecodingException;
import org.apache.qpid.framing.AMQMethodBodyFactory;
import org.apache.qpid.framing.AMQProtocolVersionException;
import org.apache.qpid.framing.BodyFactory;
import org.apache.qpid.framing.ContentBodyFactory;
import org.apache.qpid.framing.ContentHeaderBodyFactory;
import org.apache.qpid.framing.EncodingUtils;
import org.apache.qpid.framing.HeartbeatBodyFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQDataBlockDecoder {
    private static final BodyFactory[] _bodiesSupported = new BodyFactory[127];
    private Logger _logger = LoggerFactory.getLogger(AMQDataBlockDecoder.class);

    public boolean decodable(MarkableDataInput in) throws AMQFrameDecodingException, IOException {
        int remainingAfterAttributes = in.available() - 8;
        if (remainingAfterAttributes < 0) {
            return false;
        }
        in.mark(8);
        in.skip(3L);
        long bodySize = (long)in.readInt() & 0xFFFFFFFFL;
        in.reset();
        return (long)remainingAfterAttributes >= bodySize;
    }

    public AMQFrame createAndPopulateFrame(AMQMethodBodyFactory methodBodyFactory, MarkableDataInput in) throws AMQFrameDecodingException, AMQProtocolVersionException, IOException {
        byte type = in.readByte();
        BodyFactory bodyFactory = type == 1 ? methodBodyFactory : _bodiesSupported[type];
        if (bodyFactory == null) {
            throw new AMQFrameDecodingException(null, "Unsupported frame type: " + type, null);
        }
        int channel = in.readUnsignedShort();
        long bodySize = EncodingUtils.readUnsignedInteger(in);
        if (channel < 0 || bodySize < 0L) {
            throw new AMQFrameDecodingException(null, "Undecodable frame: type = " + type + " channel = " + channel + " bodySize = " + bodySize, null);
        }
        AMQFrame frame = new AMQFrame(in, channel, bodySize, bodyFactory);
        byte marker = in.readByte();
        if ((marker & 0xFF) != 206) {
            throw new AMQFrameDecodingException(null, "End of frame marker not found. Read " + marker + " length=" + bodySize + " type=" + type, null);
        }
        return frame;
    }

    static {
        AMQDataBlockDecoder._bodiesSupported[2] = ContentHeaderBodyFactory.getInstance();
        AMQDataBlockDecoder._bodiesSupported[3] = ContentBodyFactory.getInstance();
        AMQDataBlockDecoder._bodiesSupported[8] = new HeartbeatBodyFactory();
    }
}

