/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.framing;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.qpid.framing.AMQFrameDecodingException;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.ByteArrayDataInput;
import org.apache.qpid.framing.EncodingUtils;
import org.apache.qpid.framing.FieldTable;
import org.apache.qpid.framing.FieldTableFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicContentHeaderProperties {
    public static final byte NON_PERSISTENT = 1;
    public static final byte PERSISTENT = 2;
    private static final Logger _logger = LoggerFactory.getLogger(BasicContentHeaderProperties.class);
    private static final AMQShortString ZERO_STRING = null;
    private AMQShortString _contentType;
    private AMQShortString _encoding;
    private FieldTable _headers;
    private byte _deliveryMode;
    private byte _priority;
    private AMQShortString _correlationId;
    private AMQShortString _replyTo;
    private long _expiration;
    private AMQShortString _messageId;
    private long _timestamp;
    private AMQShortString _type;
    private AMQShortString _userId;
    private AMQShortString _appId;
    private AMQShortString _clusterId;
    private int _propertyFlags = 0;
    private static final int CONTENT_TYPE_MASK = 32768;
    private static final int ENCODING_MASK = 16384;
    private static final int HEADERS_MASK = 8192;
    private static final int DELIVERY_MODE_MASK = 4096;
    private static final int PRIORITY_MASK = 2048;
    private static final int CORRELATION_ID_MASK = 1024;
    private static final int REPLY_TO_MASK = 512;
    private static final int EXPIRATION_MASK = 256;
    private static final int MESSAGE_ID_MASK = 128;
    private static final int TIMESTAMP_MASK = 64;
    private static final int TYPE_MASK = 32;
    private static final int USER_ID_MASK = 16;
    private static final int APPLICATION_ID_MASK = 8;
    private static final int CLUSTER_ID_MASK = 4;
    private byte[] _encodedForm;

    public int getPropertyListSize() {
        if (this.useEncodedForm()) {
            return this._encodedForm.length;
        }
        int size = 0;
        if ((this._propertyFlags & 0x8000) > 0) {
            size += EncodingUtils.encodedShortStringLength(this._contentType);
        }
        if ((this._propertyFlags & 0x4000) > 0) {
            size += EncodingUtils.encodedShortStringLength(this._encoding);
        }
        if ((this._propertyFlags & 0x2000) > 0) {
            size += EncodingUtils.encodedFieldTableLength(this._headers);
        }
        if ((this._propertyFlags & 0x1000) > 0) {
            ++size;
        }
        if ((this._propertyFlags & 0x800) > 0) {
            ++size;
        }
        if ((this._propertyFlags & 0x400) > 0) {
            size += EncodingUtils.encodedShortStringLength(this._correlationId);
        }
        if ((this._propertyFlags & 0x200) > 0) {
            size += EncodingUtils.encodedShortStringLength(this._replyTo);
        }
        if ((this._propertyFlags & 0x100) > 0) {
            size = this._expiration == 0L ? (size += EncodingUtils.encodedShortStringLength(ZERO_STRING)) : (size += EncodingUtils.encodedShortStringLength(this._expiration));
        }
        if ((this._propertyFlags & 0x80) > 0) {
            size += EncodingUtils.encodedShortStringLength(this._messageId);
        }
        if ((this._propertyFlags & 0x40) > 0) {
            size += 8;
        }
        if ((this._propertyFlags & 0x20) > 0) {
            size += EncodingUtils.encodedShortStringLength(this._type);
        }
        if ((this._propertyFlags & 0x10) > 0) {
            size += EncodingUtils.encodedShortStringLength(this._userId);
        }
        if ((this._propertyFlags & 8) > 0) {
            size += EncodingUtils.encodedShortStringLength(this._appId);
        }
        if ((this._propertyFlags & 4) > 0) {
            size += EncodingUtils.encodedShortStringLength(this._clusterId);
        }
        return size;
    }

    public void setPropertyFlags(int propertyFlags) {
        this._propertyFlags = propertyFlags;
    }

    public int getPropertyFlags() {
        return this._propertyFlags;
    }

    public void writePropertyListPayload(DataOutput buffer) throws IOException {
        if (this.useEncodedForm()) {
            buffer.write(this._encodedForm);
        } else {
            if ((this._propertyFlags & 0x8000) != 0) {
                EncodingUtils.writeShortStringBytes(buffer, this._contentType);
            }
            if ((this._propertyFlags & 0x4000) != 0) {
                EncodingUtils.writeShortStringBytes(buffer, this._encoding);
            }
            if ((this._propertyFlags & 0x2000) != 0) {
                EncodingUtils.writeFieldTableBytes(buffer, this._headers);
            }
            if ((this._propertyFlags & 0x1000) != 0) {
                buffer.writeByte(this._deliveryMode);
            }
            if ((this._propertyFlags & 0x800) != 0) {
                buffer.writeByte(this._priority);
            }
            if ((this._propertyFlags & 0x400) != 0) {
                EncodingUtils.writeShortStringBytes(buffer, this._correlationId);
            }
            if ((this._propertyFlags & 0x200) != 0) {
                EncodingUtils.writeShortStringBytes(buffer, this._replyTo);
            }
            if ((this._propertyFlags & 0x100) != 0) {
                if (this._expiration == 0L) {
                    EncodingUtils.writeShortStringBytes(buffer, ZERO_STRING);
                } else {
                    EncodingUtils.writeShortStringBytes(buffer, String.valueOf(this._expiration));
                }
            }
            if ((this._propertyFlags & 0x80) != 0) {
                EncodingUtils.writeShortStringBytes(buffer, this._messageId);
            }
            if ((this._propertyFlags & 0x40) != 0) {
                EncodingUtils.writeTimestamp(buffer, this._timestamp);
            }
            if ((this._propertyFlags & 0x20) != 0) {
                EncodingUtils.writeShortStringBytes(buffer, this._type);
            }
            if ((this._propertyFlags & 0x10) != 0) {
                EncodingUtils.writeShortStringBytes(buffer, this._userId);
            }
            if ((this._propertyFlags & 8) != 0) {
                EncodingUtils.writeShortStringBytes(buffer, this._appId);
            }
            if ((this._propertyFlags & 4) != 0) {
                EncodingUtils.writeShortStringBytes(buffer, this._clusterId);
            }
        }
    }

    public void populatePropertiesFromBuffer(DataInput buffer, int propertyFlags, int size) throws AMQFrameDecodingException, IOException {
        this._propertyFlags = propertyFlags;
        if (_logger.isDebugEnabled()) {
            _logger.debug("Property flags: " + this._propertyFlags);
        }
        this._encodedForm = new byte[size];
        buffer.readFully(this._encodedForm);
        ByteArrayDataInput input = new ByteArrayDataInput(this._encodedForm);
        this.decode(input);
    }

    private void decode(ByteArrayDataInput buffer) throws IOException, AMQFrameDecodingException {
        int headersOffset = 0;
        if ((this._propertyFlags & 0x8000) != 0) {
            this._contentType = buffer.readAMQShortString();
            headersOffset += EncodingUtils.encodedShortStringLength(this._contentType);
        }
        if ((this._propertyFlags & 0x4000) != 0) {
            this._encoding = buffer.readAMQShortString();
            headersOffset += EncodingUtils.encodedShortStringLength(this._encoding);
        }
        if ((this._propertyFlags & 0x2000) != 0) {
            long length = EncodingUtils.readUnsignedInteger(buffer);
            this._headers = new FieldTable(this._encodedForm, headersOffset + 4, (int)length);
            buffer.skipBytes((int)length);
        }
        if ((this._propertyFlags & 0x1000) != 0) {
            this._deliveryMode = buffer.readByte();
        }
        if ((this._propertyFlags & 0x800) != 0) {
            this._priority = buffer.readByte();
        }
        if ((this._propertyFlags & 0x400) != 0) {
            this._correlationId = buffer.readAMQShortString();
        }
        if ((this._propertyFlags & 0x200) != 0) {
            this._replyTo = buffer.readAMQShortString();
        }
        if ((this._propertyFlags & 0x100) != 0) {
            this._expiration = EncodingUtils.readLongAsShortString(buffer);
        }
        if ((this._propertyFlags & 0x80) != 0) {
            this._messageId = buffer.readAMQShortString();
        }
        if ((this._propertyFlags & 0x40) != 0) {
            this._timestamp = EncodingUtils.readTimestamp(buffer);
        }
        if ((this._propertyFlags & 0x20) != 0) {
            this._type = buffer.readAMQShortString();
        }
        if ((this._propertyFlags & 0x10) != 0) {
            this._userId = buffer.readAMQShortString();
        }
        if ((this._propertyFlags & 8) != 0) {
            this._appId = buffer.readAMQShortString();
        }
        if ((this._propertyFlags & 4) != 0) {
            this._clusterId = buffer.readAMQShortString();
        }
    }

    public AMQShortString getContentType() {
        return this._contentType;
    }

    public String getContentTypeAsString() {
        return this._contentType == null ? null : this._contentType.toString();
    }

    public void setContentType(AMQShortString contentType) {
        this._propertyFlags = contentType == null ? (this._propertyFlags &= 0xFFFF7FFF) : (this._propertyFlags |= 0x8000);
        this._contentType = contentType;
        this._encodedForm = null;
    }

    public void setContentType(String contentType) {
        this.setContentType(contentType == null ? null : AMQShortString.valueOf(contentType));
    }

    public String getEncodingAsString() {
        return this.getEncoding() == null ? null : this.getEncoding().toString();
    }

    public AMQShortString getEncoding() {
        return this._encoding;
    }

    public void setEncoding(String encoding) {
        this.setEncoding(encoding == null ? null : AMQShortString.valueOf(encoding));
    }

    public void setEncoding(AMQShortString encoding) {
        this._propertyFlags = encoding == null ? (this._propertyFlags &= 0xFFFFBFFF) : (this._propertyFlags |= 0x4000);
        this._encoding = encoding;
        this._encodedForm = null;
    }

    public FieldTable getHeaders() {
        if (this._headers == null) {
            this.setHeaders(FieldTableFactory.newFieldTable());
        }
        return this._headers;
    }

    public void setHeaders(FieldTable headers) {
        this._propertyFlags = headers == null ? (this._propertyFlags &= 0xFFFFDFFF) : (this._propertyFlags |= 0x2000);
        this._headers = headers;
        this._encodedForm = null;
    }

    public byte getDeliveryMode() {
        return this._deliveryMode;
    }

    public void setDeliveryMode(byte deliveryMode) {
        this._propertyFlags |= 0x1000;
        this._deliveryMode = deliveryMode;
        this._encodedForm = null;
    }

    public byte getPriority() {
        return this._priority;
    }

    public void setPriority(byte priority) {
        this._propertyFlags |= 0x800;
        this._priority = priority;
        this._encodedForm = null;
    }

    public AMQShortString getCorrelationId() {
        return this._correlationId;
    }

    public String getCorrelationIdAsString() {
        return this._correlationId == null ? null : this._correlationId.toString();
    }

    public void setCorrelationId(String correlationId) {
        this.setCorrelationId(correlationId == null ? null : AMQShortString.valueOf(correlationId));
    }

    public void setCorrelationId(AMQShortString correlationId) {
        this._propertyFlags = correlationId == null ? (this._propertyFlags &= 0xFFFFFBFF) : (this._propertyFlags |= 0x400);
        this._correlationId = correlationId;
        this._encodedForm = null;
    }

    public String getReplyToAsString() {
        return this._replyTo == null ? null : this._replyTo.toString();
    }

    public AMQShortString getReplyTo() {
        return this._replyTo;
    }

    public void setReplyTo(String replyTo) {
        this.setReplyTo(replyTo == null ? null : AMQShortString.valueOf(replyTo));
    }

    public void setReplyTo(AMQShortString replyTo) {
        this._propertyFlags = replyTo == null ? (this._propertyFlags &= 0xFFFFFDFF) : (this._propertyFlags |= 0x200);
        this._replyTo = replyTo;
        this._encodedForm = null;
    }

    public long getExpiration() {
        return this._expiration;
    }

    public void setExpiration(long expiration) {
        this._propertyFlags = expiration == 0L ? (this._propertyFlags &= 0xFFFFFEFF) : (this._propertyFlags |= 0x100);
        this._expiration = expiration;
        this._encodedForm = null;
    }

    public AMQShortString getMessageId() {
        return this._messageId;
    }

    public String getMessageIdAsString() {
        return this._messageId == null ? null : this._messageId.toString();
    }

    public void setMessageId(String messageId) {
        this.setMessageId(messageId == null ? null : new AMQShortString(messageId));
    }

    public void setMessageId(AMQShortString messageId) {
        this._propertyFlags = messageId == null ? (this._propertyFlags &= 0xFFFFFF7F) : (this._propertyFlags |= 0x80);
        this._messageId = messageId;
        this._encodedForm = null;
    }

    public long getTimestamp() {
        return this._timestamp;
    }

    public void setTimestamp(long timestamp) {
        this._propertyFlags |= 0x40;
        this._timestamp = timestamp;
        this._encodedForm = null;
    }

    public String getTypeAsString() {
        return this._type == null ? null : this._type.toString();
    }

    public AMQShortString getType() {
        return this._type;
    }

    public void setType(String type) {
        this.setType(type == null ? null : AMQShortString.valueOf(type));
    }

    public void setType(AMQShortString type) {
        this._propertyFlags = type == null ? (this._propertyFlags &= 0xFFFFFFDF) : (this._propertyFlags |= 0x20);
        this._type = type;
        this._encodedForm = null;
    }

    public String getUserIdAsString() {
        return this._userId == null ? null : this._userId.toString();
    }

    public AMQShortString getUserId() {
        return this._userId;
    }

    public void setUserId(String userId) {
        this.setUserId(userId == null ? null : AMQShortString.valueOf(userId));
    }

    public void setUserId(AMQShortString userId) {
        this._propertyFlags = userId == null ? (this._propertyFlags &= 0xFFFFFFEF) : (this._propertyFlags |= 0x10);
        this._userId = userId;
        this._encodedForm = null;
    }

    public String getAppIdAsString() {
        return this._appId == null ? null : this._appId.toString();
    }

    public AMQShortString getAppId() {
        return this._appId;
    }

    public void setAppId(String appId) {
        this.setAppId(appId == null ? null : AMQShortString.valueOf(appId));
    }

    public void setAppId(AMQShortString appId) {
        this._propertyFlags = appId == null ? (this._propertyFlags &= 0xFFFFFFF7) : (this._propertyFlags |= 8);
        this._appId = appId;
        this._encodedForm = null;
    }

    public String getClusterIdAsString() {
        return this._clusterId == null ? null : this._clusterId.toString();
    }

    public AMQShortString getClusterId() {
        return this._clusterId;
    }

    public void setClusterId(String clusterId) {
        this.setClusterId(clusterId == null ? null : AMQShortString.valueOf(clusterId));
    }

    public void setClusterId(AMQShortString clusterId) {
        this._propertyFlags = clusterId == null ? (this._propertyFlags &= 0xFFFFFFFB) : (this._propertyFlags |= 4);
        this._clusterId = clusterId;
        this._encodedForm = null;
    }

    public String toString() {
        return "reply-to = " + this._replyTo + ",propertyFlags = " + this._propertyFlags + ",ApplicationID = " + this._appId + ",ClusterID = " + this._clusterId + ",UserId = " + this._userId + ",JMSMessageID = " + this._messageId + ",JMSCorrelationID = " + this._correlationId + ",JMSDeliveryMode = " + this._deliveryMode + ",JMSExpiration = " + this._expiration + ",JMSPriority = " + this._priority + ",JMSTimestamp = " + this._timestamp + ",JMSType = " + this._type;
    }

    private boolean useEncodedForm() {
        return this._encodedForm != null && (this._headers == null || this._headers.isClean());
    }
}

