/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.framing.amqp_0_9;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.qpid.AMQException;
import org.apache.qpid.codec.MarkableDataInput;
import org.apache.qpid.framing.AMQFrameDecodingException;
import org.apache.qpid.framing.AMQMethodBody;
import org.apache.qpid.framing.AMQMethodBodyInstanceFactory;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.BasicGetBody;
import org.apache.qpid.framing.MethodDispatcher;
import org.apache.qpid.framing.amqp_0_9.AMQMethodBody_0_9;
import org.apache.qpid.framing.amqp_0_9.MethodDispatcher_0_9;

public class BasicGetBodyImpl
extends AMQMethodBody_0_9
implements BasicGetBody {
    private static final AMQMethodBodyInstanceFactory FACTORY_INSTANCE = new AMQMethodBodyInstanceFactory(){

        @Override
        public AMQMethodBody newInstance(MarkableDataInput in, long size) throws AMQFrameDecodingException, IOException {
            return new BasicGetBodyImpl(in);
        }
    };
    public static final int CLASS_ID = 60;
    public static final int METHOD_ID = 70;
    private final int _ticket;
    private final AMQShortString _queue;
    private final byte _bitfield0;

    public static AMQMethodBodyInstanceFactory getFactory() {
        return FACTORY_INSTANCE;
    }

    public BasicGetBodyImpl(MarkableDataInput buffer) throws AMQFrameDecodingException, IOException {
        this._ticket = this.readUnsignedShort(buffer);
        this._queue = this.readAMQShortString(buffer);
        this._bitfield0 = this.readBitfield(buffer);
    }

    public BasicGetBodyImpl(int ticket, AMQShortString queue, boolean noAck) {
        this._ticket = ticket;
        this._queue = queue;
        byte bitfield0 = 0;
        if (noAck) {
            bitfield0 = (byte)(bitfield0 | 1);
        }
        this._bitfield0 = bitfield0;
    }

    @Override
    public int getClazz() {
        return 60;
    }

    @Override
    public int getMethod() {
        return 70;
    }

    @Override
    public final int getTicket() {
        return this._ticket;
    }

    @Override
    public final AMQShortString getQueue() {
        return this._queue;
    }

    @Override
    public final boolean getNoAck() {
        return (this._bitfield0 & 1) != 0;
    }

    @Override
    protected int getBodySize() {
        int size = 3;
        return size += this.getSizeOf(this._queue);
    }

    @Override
    public void writeMethodPayload(DataOutput buffer) throws IOException {
        this.writeUnsignedShort(buffer, this._ticket);
        this.writeAMQShortString(buffer, this._queue);
        this.writeBitfield(buffer, this._bitfield0);
    }

    @Override
    public boolean execute(MethodDispatcher dispatcher, int channelId) throws AMQException {
        return ((MethodDispatcher_0_9)dispatcher).dispatchBasicGet(this, channelId);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder("[BasicGetBodyImpl: ");
        buf.append("ticket=");
        buf.append(this.getTicket());
        buf.append(", ");
        buf.append("queue=");
        buf.append(this.getQueue());
        buf.append(", ");
        buf.append("noAck=");
        buf.append(this.getNoAck());
        buf.append("]");
        return buf.toString();
    }
}

