/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.framing.amqp_0_91;

import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.qpid.AMQException;
import org.apache.qpid.codec.MarkableDataInput;
import org.apache.qpid.framing.AMQFrameDecodingException;
import org.apache.qpid.framing.AMQMethodBody;
import org.apache.qpid.framing.AMQMethodBodyInstanceFactory;
import org.apache.qpid.framing.ConnectionStartBody;
import org.apache.qpid.framing.FieldTable;
import org.apache.qpid.framing.MethodDispatcher;
import org.apache.qpid.framing.amqp_0_91.AMQMethodBody_0_91;
import org.apache.qpid.framing.amqp_0_91.MethodDispatcher_0_91;

public class ConnectionStartBodyImpl
extends AMQMethodBody_0_91
implements ConnectionStartBody {
    private static final AMQMethodBodyInstanceFactory FACTORY_INSTANCE = new AMQMethodBodyInstanceFactory(){

        @Override
        public AMQMethodBody newInstance(MarkableDataInput in, long size) throws AMQFrameDecodingException, IOException {
            return new ConnectionStartBodyImpl(in);
        }
    };
    public static final int CLASS_ID = 10;
    public static final int METHOD_ID = 10;
    private final short _versionMajor;
    private final short _versionMinor;
    private final FieldTable _serverProperties;
    private final byte[] _mechanisms;
    private final byte[] _locales;

    public static AMQMethodBodyInstanceFactory getFactory() {
        return FACTORY_INSTANCE;
    }

    public ConnectionStartBodyImpl(MarkableDataInput buffer) throws AMQFrameDecodingException, IOException {
        this._versionMajor = this.readUnsignedByte(buffer);
        this._versionMinor = this.readUnsignedByte(buffer);
        this._serverProperties = this.readFieldTable(buffer);
        this._mechanisms = this.readBytes(buffer);
        this._locales = this.readBytes(buffer);
    }

    public ConnectionStartBodyImpl(short versionMajor, short versionMinor, FieldTable serverProperties, byte[] mechanisms, byte[] locales) {
        this._versionMajor = versionMajor;
        this._versionMinor = versionMinor;
        this._serverProperties = serverProperties;
        this._mechanisms = mechanisms;
        this._locales = locales;
    }

    @Override
    public int getClazz() {
        return 10;
    }

    @Override
    public int getMethod() {
        return 10;
    }

    @Override
    public final short getVersionMajor() {
        return this._versionMajor;
    }

    @Override
    public final short getVersionMinor() {
        return this._versionMinor;
    }

    @Override
    public final FieldTable getServerProperties() {
        return this._serverProperties;
    }

    @Override
    public final byte[] getMechanisms() {
        return this._mechanisms;
    }

    @Override
    public final byte[] getLocales() {
        return this._locales;
    }

    @Override
    protected int getBodySize() {
        int size = 2;
        size += this.getSizeOf(this._serverProperties);
        size += this.getSizeOf(this._mechanisms);
        return size += this.getSizeOf(this._locales);
    }

    @Override
    public void writeMethodPayload(DataOutput buffer) throws IOException {
        this.writeUnsignedByte(buffer, this._versionMajor);
        this.writeUnsignedByte(buffer, this._versionMinor);
        this.writeFieldTable(buffer, this._serverProperties);
        this.writeBytes(buffer, this._mechanisms);
        this.writeBytes(buffer, this._locales);
    }

    @Override
    public boolean execute(MethodDispatcher dispatcher, int channelId) throws AMQException {
        return ((MethodDispatcher_0_91)dispatcher).dispatchConnectionStart(this, channelId);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder("[ConnectionStartBodyImpl: ");
        buf.append("versionMajor=");
        buf.append(this.getVersionMajor());
        buf.append(", ");
        buf.append("versionMinor=");
        buf.append(this.getVersionMinor());
        buf.append(", ");
        buf.append("serverProperties=");
        buf.append(this.getServerProperties());
        buf.append(", ");
        buf.append("mechanisms=");
        buf.append(this.getMechanisms() == null ? "null" : Arrays.toString(this.getMechanisms()));
        buf.append(", ");
        buf.append("locales=");
        buf.append(this.getLocales() == null ? "null" : Arrays.toString(this.getLocales()));
        buf.append("]");
        return buf.toString();
    }
}

