/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.framing.amqp_8_0;

import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.qpid.AMQException;
import org.apache.qpid.codec.MarkableDataInput;
import org.apache.qpid.framing.AMQFrameDecodingException;
import org.apache.qpid.framing.AMQMethodBody;
import org.apache.qpid.framing.AMQMethodBodyInstanceFactory;
import org.apache.qpid.framing.ConnectionSecureOkBody;
import org.apache.qpid.framing.MethodDispatcher;
import org.apache.qpid.framing.amqp_8_0.AMQMethodBody_8_0;
import org.apache.qpid.framing.amqp_8_0.MethodDispatcher_8_0;

public class ConnectionSecureOkBodyImpl
extends AMQMethodBody_8_0
implements ConnectionSecureOkBody {
    private static final AMQMethodBodyInstanceFactory FACTORY_INSTANCE = new AMQMethodBodyInstanceFactory(){

        @Override
        public AMQMethodBody newInstance(MarkableDataInput in, long size) throws AMQFrameDecodingException, IOException {
            return new ConnectionSecureOkBodyImpl(in);
        }
    };
    public static final int CLASS_ID = 10;
    public static final int METHOD_ID = 21;
    private final byte[] _response;

    public static AMQMethodBodyInstanceFactory getFactory() {
        return FACTORY_INSTANCE;
    }

    public ConnectionSecureOkBodyImpl(MarkableDataInput buffer) throws AMQFrameDecodingException, IOException {
        this._response = this.readBytes(buffer);
    }

    public ConnectionSecureOkBodyImpl(byte[] response) {
        this._response = response;
    }

    @Override
    public int getClazz() {
        return 10;
    }

    @Override
    public int getMethod() {
        return 21;
    }

    @Override
    public final byte[] getResponse() {
        return this._response;
    }

    @Override
    protected int getBodySize() {
        int size = 0;
        return size += this.getSizeOf(this._response);
    }

    @Override
    public void writeMethodPayload(DataOutput buffer) throws IOException {
        this.writeBytes(buffer, this._response);
    }

    @Override
    public boolean execute(MethodDispatcher dispatcher, int channelId) throws AMQException {
        return ((MethodDispatcher_8_0)dispatcher).dispatchConnectionSecureOk(this, channelId);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder("[ConnectionSecureOkBodyImpl: ");
        buf.append("response=");
        buf.append(this.getResponse() == null ? "null" : Arrays.toString(this.getResponse()));
        buf.append("]");
        return buf.toString();
    }
}

