/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.transport;

import java.security.KeyStore;
import java.util.Map;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.apache.qpid.configuration.QpidProperty;

public class ConnectionSettings {
    public static final String WILDCARD_ADDRESS = "*";
    private String protocol = "tcp";
    private String host = "localhost";
    private String vhost;
    private String username = "guest";
    private String password = "guest";
    private int port = 5672;
    private boolean tcpNodelay = QpidProperty.booleanProperty(Boolean.TRUE, "qpid.tcp_nodelay", "amqj.tcp_nodelay").get();
    private int maxChannelCount = Short.MAX_VALUE;
    private int maxFrameSize = 65535;
    private Integer hearbeatIntervalLegacyMs = QpidProperty.intProperty(null, "idle_timeout").get();
    private Integer heartbeatInterval = QpidProperty.intProperty(null, "qpid.heartbeat", "amqj.heartbeat.delay").get();
    private float heartbeatTimeoutFactor = QpidProperty.floatProperty(Float.valueOf(2.0f), "qpid.heartbeat_timeout_factor", "amqj.heartbeat.timeoutFactor").get().floatValue();
    private int connectTimeout = 30000;
    private int readBufferSize = QpidProperty.intProperty(65535, "qpid.receive_buffer_size", "amqj.receiveBufferSize").get();
    private int writeBufferSize = QpidProperty.intProperty(65535, "qpid.send_buffer_size", "amqj.sendBufferSize").get();
    private boolean useSSL;
    private String keyStorePath = System.getProperty("javax.net.ssl.keyStore");
    private String keyStorePassword = System.getProperty("javax.net.ssl.keyStorePassword");
    private String keyStoreType = System.getProperty("javax.net.ssl.keyStoreType", KeyStore.getDefaultType());
    private String keyManagerFactoryAlgorithm = QpidProperty.stringProperty(KeyManagerFactory.getDefaultAlgorithm(), "qpid.ssl.KeyManagerFactory.algorithm", "qpid.ssl.keyStoreCertType").get();
    private String trustManagerFactoryAlgorithm = QpidProperty.stringProperty(TrustManagerFactory.getDefaultAlgorithm(), "qpid.ssl.TrustManagerFactory.algorithm", "qpid.ssl.trustStoreCertType").get();
    private String trustStorePath = System.getProperty("javax.net.ssl.trustStore");
    private String trustStorePassword = System.getProperty("javax.net.ssl.trustStorePassword");
    private String trustStoreType = System.getProperty("javax.net.ssl.trustStoreType", KeyStore.getDefaultType());
    private String certAlias;
    private boolean verifyHostname;
    private String saslMechs = System.getProperty("qpid.sasl_mechs", null);
    private String saslProtocol = System.getProperty("qpid.sasl_protocol", "AMQP");
    private String saslServerName = System.getProperty("qpid.sasl_server_name", "localhost");
    private boolean useSASLEncryption;
    private Map<String, Object> _clientProperties;

    public boolean isTcpNodelay() {
        return this.tcpNodelay;
    }

    public void setTcpNodelay(boolean tcpNodelay) {
        this.tcpNodelay = tcpNodelay;
    }

    public Integer getHeartbeatInterval08() {
        if (this.heartbeatInterval != null) {
            return this.heartbeatInterval;
        }
        if (this.hearbeatIntervalLegacyMs != null) {
            return this.hearbeatIntervalLegacyMs / 1000;
        }
        return null;
    }

    public int getHeartbeatInterval010() {
        if (this.heartbeatInterval != null) {
            return this.heartbeatInterval;
        }
        if (this.hearbeatIntervalLegacyMs != null) {
            return this.hearbeatIntervalLegacyMs / 1000;
        }
        return 120;
    }

    public void setHeartbeatInterval(int heartbeatInterval) {
        this.heartbeatInterval = heartbeatInterval;
    }

    public float getHeartbeatTimeoutFactor() {
        return this.heartbeatTimeoutFactor;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getVhost() {
        return this.vhost;
    }

    public void setVhost(String vhost) {
        this.vhost = vhost;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isUseSSL() {
        return this.useSSL;
    }

    public void setUseSSL(boolean useSSL) {
        this.useSSL = useSSL;
    }

    public boolean isUseSASLEncryption() {
        return this.useSASLEncryption;
    }

    public void setUseSASLEncryption(boolean useSASLEncryption) {
        this.useSASLEncryption = useSASLEncryption;
    }

    public String getSaslMechs() {
        return this.saslMechs;
    }

    public void setSaslMechs(String saslMechs) {
        this.saslMechs = saslMechs;
    }

    public String getSaslProtocol() {
        return this.saslProtocol;
    }

    public void setSaslProtocol(String saslProtocol) {
        this.saslProtocol = saslProtocol;
    }

    public String getSaslServerName() {
        return this.saslServerName;
    }

    public void setSaslServerName(String saslServerName) {
        this.saslServerName = saslServerName;
    }

    public int getMaxChannelCount() {
        return this.maxChannelCount;
    }

    public void setMaxChannelCount(int maxChannelCount) {
        this.maxChannelCount = maxChannelCount;
    }

    public int getMaxFrameSize() {
        return this.maxFrameSize;
    }

    public void setMaxFrameSize(int maxFrameSize) {
        this.maxFrameSize = maxFrameSize;
    }

    public void setClientProperties(Map<String, Object> clientProperties) {
        this._clientProperties = clientProperties;
    }

    public Map<String, Object> getClientProperties() {
        return this._clientProperties;
    }

    public String getKeyStorePath() {
        return this.keyStorePath;
    }

    public void setKeyStorePath(String keyStorePath) {
        this.keyStorePath = keyStorePath;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    public void setKeyStoreType(String keyStoreType) {
        this.keyStoreType = keyStoreType;
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public String getTrustStorePath() {
        return this.trustStorePath;
    }

    public void setTrustStorePath(String trustStorePath) {
        this.trustStorePath = trustStorePath;
    }

    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public void setTrustStorePassword(String trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
    }

    public String getCertAlias() {
        return this.certAlias;
    }

    public void setCertAlias(String certAlias) {
        this.certAlias = certAlias;
    }

    public boolean isVerifyHostname() {
        return this.verifyHostname;
    }

    public void setVerifyHostname(boolean verifyHostname) {
        this.verifyHostname = verifyHostname;
    }

    public String getKeyManagerFactoryAlgorithm() {
        return this.keyManagerFactoryAlgorithm;
    }

    public void setKeyManagerFactoryAlgorithm(String keyManagerFactoryAlgorithm) {
        this.keyManagerFactoryAlgorithm = keyManagerFactoryAlgorithm;
    }

    public String getTrustManagerFactoryAlgorithm() {
        return this.trustManagerFactoryAlgorithm;
    }

    public void setTrustManagerFactoryAlgorithm(String trustManagerFactoryAlgorithm) {
        this.trustManagerFactoryAlgorithm = trustManagerFactoryAlgorithm;
    }

    public String getTrustStoreType() {
        return this.trustStoreType;
    }

    public void setTrustStoreType(String trustStoreType) {
        this.trustStoreType = trustStoreType;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int getReadBufferSize() {
        return this.readBufferSize;
    }

    public void setReadBufferSize(int readBufferSize) {
        this.readBufferSize = readBufferSize;
    }

    public int getWriteBufferSize() {
        return this.writeBufferSize;
    }

    public void setWriteBufferSize(int writeBufferSize) {
        this.writeBufferSize = writeBufferSize;
    }
}

