/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.transport;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.qpid.transport.Option;
import org.apache.qpid.transport.Struct;
import org.apache.qpid.transport.codec.Decoder;
import org.apache.qpid.transport.codec.Encoder;

public final class QueueQueryResult
extends Struct {
    public static final int TYPE = 2049;
    private short packing_flags = 0;
    private String queue;
    private String alternateExchange;
    private Map<String, Object> arguments;
    private long messageCount;
    private long subscriberCount;

    @Override
    public final int getStructType() {
        return 2049;
    }

    @Override
    public final int getSizeWidth() {
        return 4;
    }

    @Override
    public final int getPackWidth() {
        return 2;
    }

    public final boolean hasPayload() {
        return false;
    }

    public final byte getEncodedTrack() {
        return -1;
    }

    public final boolean isConnectionControl() {
        return false;
    }

    public QueueQueryResult() {
    }

    public QueueQueryResult(String queue, String alternateExchange, Map<String, Object> arguments, long messageCount, long subscriberCount, Option ... _options) {
        if (queue != null) {
            this.setQueue(queue);
        }
        if (alternateExchange != null) {
            this.setAlternateExchange(alternateExchange);
        }
        if (arguments != null) {
            this.setArguments(arguments);
        }
        this.setMessageCount(messageCount);
        this.setSubscriberCount(subscriberCount);
        block6: for (int i = 0; i < _options.length; ++i) {
            switch (_options[i]) {
                case DURABLE: {
                    this.packing_flags = (short)(this.packing_flags | 0x400);
                    continue block6;
                }
                case EXCLUSIVE: {
                    this.packing_flags = (short)(this.packing_flags | 0x800);
                    continue block6;
                }
                case AUTO_DELETE: {
                    this.packing_flags = (short)(this.packing_flags | 0x1000);
                    continue block6;
                }
                case NONE: {
                    continue block6;
                }
                default: {
                    throw new IllegalArgumentException("invalid option: " + (Object)((Object)_options[i]));
                }
            }
        }
    }

    public final boolean hasQueue() {
        return (this.packing_flags & 0x100) != 0;
    }

    public final QueueQueryResult clearQueue() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFFEFF);
        this.queue = null;
        this.setDirty(true);
        return this;
    }

    public final String getQueue() {
        return this.queue;
    }

    public final QueueQueryResult setQueue(String value) {
        this.queue = value;
        this.packing_flags = (short)(this.packing_flags | 0x100);
        this.setDirty(true);
        return this;
    }

    public final QueueQueryResult queue(String value) {
        return this.setQueue(value);
    }

    public final boolean hasAlternateExchange() {
        return (this.packing_flags & 0x200) != 0;
    }

    public final QueueQueryResult clearAlternateExchange() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFFDFF);
        this.alternateExchange = null;
        this.setDirty(true);
        return this;
    }

    public final String getAlternateExchange() {
        return this.alternateExchange;
    }

    public final QueueQueryResult setAlternateExchange(String value) {
        this.alternateExchange = value;
        this.packing_flags = (short)(this.packing_flags | 0x200);
        this.setDirty(true);
        return this;
    }

    public final QueueQueryResult alternateExchange(String value) {
        return this.setAlternateExchange(value);
    }

    public final boolean hasDurable() {
        return (this.packing_flags & 0x400) != 0;
    }

    public final QueueQueryResult clearDurable() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFFBFF);
        this.setDirty(true);
        return this;
    }

    public final boolean getDurable() {
        return this.hasDurable();
    }

    public final QueueQueryResult setDurable(boolean value) {
        this.packing_flags = value ? (short)(this.packing_flags | 0x400) : (short)(this.packing_flags & 0xFFFFFBFF);
        this.setDirty(true);
        return this;
    }

    public final QueueQueryResult durable(boolean value) {
        return this.setDurable(value);
    }

    public final boolean hasExclusive() {
        return (this.packing_flags & 0x800) != 0;
    }

    public final QueueQueryResult clearExclusive() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFF7FF);
        this.setDirty(true);
        return this;
    }

    public final boolean getExclusive() {
        return this.hasExclusive();
    }

    public final QueueQueryResult setExclusive(boolean value) {
        this.packing_flags = value ? (short)(this.packing_flags | 0x800) : (short)(this.packing_flags & 0xFFFFF7FF);
        this.setDirty(true);
        return this;
    }

    public final QueueQueryResult exclusive(boolean value) {
        return this.setExclusive(value);
    }

    public final boolean hasAutoDelete() {
        return (this.packing_flags & 0x1000) != 0;
    }

    public final QueueQueryResult clearAutoDelete() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFEFFF);
        this.setDirty(true);
        return this;
    }

    public final boolean getAutoDelete() {
        return this.hasAutoDelete();
    }

    public final QueueQueryResult setAutoDelete(boolean value) {
        this.packing_flags = value ? (short)(this.packing_flags | 0x1000) : (short)(this.packing_flags & 0xFFFFEFFF);
        this.setDirty(true);
        return this;
    }

    public final QueueQueryResult autoDelete(boolean value) {
        return this.setAutoDelete(value);
    }

    public final boolean hasArguments() {
        return (this.packing_flags & 0x2000) != 0;
    }

    public final QueueQueryResult clearArguments() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFDFFF);
        this.arguments = null;
        this.setDirty(true);
        return this;
    }

    public final Map<String, Object> getArguments() {
        return this.arguments;
    }

    public final QueueQueryResult setArguments(Map<String, Object> value) {
        this.arguments = value;
        this.packing_flags = (short)(this.packing_flags | 0x2000);
        this.setDirty(true);
        return this;
    }

    public final QueueQueryResult arguments(Map<String, Object> value) {
        return this.setArguments(value);
    }

    public final boolean hasMessageCount() {
        return (this.packing_flags & 0x4000) != 0;
    }

    public final QueueQueryResult clearMessageCount() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFBFFF);
        this.messageCount = 0L;
        this.setDirty(true);
        return this;
    }

    public final long getMessageCount() {
        return this.messageCount;
    }

    public final QueueQueryResult setMessageCount(long value) {
        this.messageCount = value;
        this.packing_flags = (short)(this.packing_flags | 0x4000);
        this.setDirty(true);
        return this;
    }

    public final QueueQueryResult messageCount(long value) {
        return this.setMessageCount(value);
    }

    public final boolean hasSubscriberCount() {
        return (this.packing_flags & 0x8000) != 0;
    }

    public final QueueQueryResult clearSubscriberCount() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFF7FFF);
        this.subscriberCount = 0L;
        this.setDirty(true);
        return this;
    }

    public final long getSubscriberCount() {
        return this.subscriberCount;
    }

    public final QueueQueryResult setSubscriberCount(long value) {
        this.subscriberCount = value;
        this.packing_flags = (short)(this.packing_flags | 0x8000);
        this.setDirty(true);
        return this;
    }

    public final QueueQueryResult subscriberCount(long value) {
        return this.setSubscriberCount(value);
    }

    @Override
    public void write(Encoder enc) {
        enc.writeUint16(this.packing_flags);
        if ((this.packing_flags & 0x100) != 0) {
            enc.writeStr8(this.queue);
        }
        if ((this.packing_flags & 0x200) != 0) {
            enc.writeStr8(this.alternateExchange);
        }
        if ((this.packing_flags & 0x2000) != 0) {
            enc.writeMap(this.arguments);
        }
        if ((this.packing_flags & 0x4000) != 0) {
            enc.writeUint32(this.messageCount);
        }
        if ((this.packing_flags & 0x8000) != 0) {
            enc.writeUint32(this.subscriberCount);
        }
    }

    @Override
    public void read(Decoder dec) {
        this.packing_flags = (short)dec.readUint16();
        if ((this.packing_flags & 0x100) != 0) {
            this.queue = dec.readStr8();
        }
        if ((this.packing_flags & 0x200) != 0) {
            this.alternateExchange = dec.readStr8();
        }
        if ((this.packing_flags & 0x2000) != 0) {
            this.arguments = dec.readMap();
        }
        if ((this.packing_flags & 0x4000) != 0) {
            this.messageCount = dec.readUint32();
        }
        if ((this.packing_flags & 0x8000) != 0) {
            this.subscriberCount = dec.readUint32();
        }
    }

    @Override
    public Map<String, Object> getFields() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        if ((this.packing_flags & 0x100) != 0) {
            result.put("queue", this.getQueue());
        }
        if ((this.packing_flags & 0x200) != 0) {
            result.put("alternateExchange", this.getAlternateExchange());
        }
        if ((this.packing_flags & 0x400) != 0) {
            result.put("durable", this.getDurable());
        }
        if ((this.packing_flags & 0x800) != 0) {
            result.put("exclusive", this.getExclusive());
        }
        if ((this.packing_flags & 0x1000) != 0) {
            result.put("autoDelete", this.getAutoDelete());
        }
        if ((this.packing_flags & 0x2000) != 0) {
            result.put("arguments", this.getArguments());
        }
        if ((this.packing_flags & 0x4000) != 0) {
            result.put("messageCount", this.getMessageCount());
        }
        if ((this.packing_flags & 0x8000) != 0) {
            result.put("subscriberCount", this.getSubscriberCount());
        }
        return result;
    }
}

