/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.policy;

import org.apache.qpid.jms.JmsDestination;
import org.apache.qpid.jms.JmsSession;
import org.apache.qpid.jms.policy.JmsPresettlePolicy;

public class JmsDefaultPresettlePolicy
implements JmsPresettlePolicy {
    private boolean presettleAll;
    private boolean presettleProducers;
    private boolean presettleTopicProducers;
    private boolean presettleQueueProducers;
    private boolean presettleTransactedProducers;
    private boolean presettleConsumers;
    private boolean presettleTopicConsumers;
    private boolean presettleQueueConsumers;

    public JmsDefaultPresettlePolicy() {
    }

    public JmsDefaultPresettlePolicy(JmsDefaultPresettlePolicy source) {
        this.presettleAll = source.presettleAll;
        this.presettleProducers = source.presettleProducers;
        this.presettleTopicProducers = source.presettleTopicProducers;
        this.presettleQueueProducers = source.presettleQueueProducers;
        this.presettleTransactedProducers = source.presettleTransactedProducers;
        this.presettleConsumers = source.presettleConsumers;
        this.presettleTopicConsumers = source.presettleTopicConsumers;
        this.presettleQueueConsumers = source.presettleQueueConsumers;
    }

    @Override
    public JmsDefaultPresettlePolicy copy() {
        return new JmsDefaultPresettlePolicy(this);
    }

    @Override
    public boolean isConsumerPresttled(JmsSession session, JmsDestination destination) {
        if (session.isTransacted()) {
            return false;
        }
        if (destination != null && (this.presettleAll || this.presettleConsumers)) {
            return true;
        }
        if (destination != null && destination.isQueue() && this.presettleQueueConsumers) {
            return true;
        }
        return destination != null && destination.isTopic() && this.presettleTopicConsumers;
    }

    @Override
    public boolean isProducerPresttled(JmsSession session, JmsDestination destination) {
        if (this.presettleAll || this.presettleProducers) {
            return true;
        }
        if (destination != null && session.isTransacted() && this.presettleTransactedProducers) {
            return true;
        }
        if (destination != null && destination.isQueue() && this.presettleQueueProducers) {
            return true;
        }
        return destination != null && destination.isTopic() && this.presettleTopicProducers;
    }

    public boolean isPresettleAll() {
        return this.presettleAll;
    }

    public void setPresettleAll(boolean presettleAll) {
        this.presettleAll = presettleAll;
    }

    public boolean isPresettleProducers() {
        return this.presettleAll || this.presettleProducers;
    }

    public void setPresettleProducers(boolean presettleProducers) {
        this.presettleProducers = presettleProducers;
    }

    public boolean isPresettleTopicProducers() {
        return this.presettleAll || this.presettleProducers || this.presettleTopicProducers;
    }

    public void setPresettleTopicProducers(boolean presettleTopicProducers) {
        this.presettleTopicProducers = presettleTopicProducers;
    }

    public boolean isPresettleQueueProducers() {
        return this.presettleAll || this.presettleProducers || this.presettleQueueProducers;
    }

    public void setPresettleQueueProducers(boolean presettleQueueProducers) {
        this.presettleQueueProducers = presettleQueueProducers;
    }

    public boolean isPresettleTransactedProducers() {
        return this.presettleAll || this.presettleProducers || this.presettleTransactedProducers;
    }

    public void setPresettleTransactedProducers(boolean presettleTransactedProducers) {
        this.presettleTransactedProducers = presettleTransactedProducers;
    }

    public boolean isPresettleConsumers() {
        return this.presettleAll || this.presettleConsumers;
    }

    public void setPresettleConsumers(boolean presettleConsumers) {
        this.presettleConsumers = presettleConsumers;
    }

    public boolean isPresettleTopicConsumers() {
        return this.presettleAll || this.presettleConsumers || this.presettleTopicConsumers;
    }

    public void setPresettleTopicConsumers(boolean presettleTopicConsumers) {
        this.presettleTopicConsumers = presettleTopicConsumers;
    }

    public boolean isPresettleQueueConsumers() {
        return this.presettleAll || this.presettleConsumers || this.presettleQueueConsumers;
    }

    public void setPresettleQueueConsumers(boolean presettleQueueConsumers) {
        this.presettleQueueConsumers = presettleQueueConsumers;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.presettleAll ? 1231 : 1237);
        result = 31 * result + (this.presettleConsumers ? 1231 : 1237);
        result = 31 * result + (this.presettleProducers ? 1231 : 1237);
        result = 31 * result + (this.presettleQueueConsumers ? 1231 : 1237);
        result = 31 * result + (this.presettleQueueProducers ? 1231 : 1237);
        result = 31 * result + (this.presettleTopicConsumers ? 1231 : 1237);
        result = 31 * result + (this.presettleTopicProducers ? 1231 : 1237);
        result = 31 * result + (this.presettleTransactedProducers ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JmsDefaultPresettlePolicy other = (JmsDefaultPresettlePolicy)obj;
        if (this.presettleAll != other.presettleAll) {
            return false;
        }
        if (this.presettleConsumers != other.presettleConsumers) {
            return false;
        }
        if (this.presettleProducers != other.presettleProducers) {
            return false;
        }
        if (this.presettleQueueConsumers != other.presettleQueueConsumers) {
            return false;
        }
        if (this.presettleQueueProducers != other.presettleQueueProducers) {
            return false;
        }
        if (this.presettleTopicConsumers != other.presettleTopicConsumers) {
            return false;
        }
        if (this.presettleTopicProducers != other.presettleTopicProducers) {
            return false;
        }
        return this.presettleTransactedProducers == other.presettleTransactedProducers;
    }
}

