/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.message;

import java.util.Locale;
import java.util.UUID;
import org.apache.qpid.jms.provider.amqp.message.AmqpMessageIdHelper;

public interface JmsMessageIDBuilder {
    public Object createMessageID(String var1, long var2);

    public static enum BUILTIN {
        DEFAULT{

            @Override
            public JmsMessageIDBuilder createBuilder() {
                return new JmsMessageIDBuilder(){

                    @Override
                    public Object createMessageID(String producerId, long messageSequence) {
                        String messageId = producerId + "-" + messageSequence;
                        if (!AmqpMessageIdHelper.hasMessageIdPrefix(messageId)) {
                            messageId = "ID:" + messageId;
                        }
                        return messageId;
                    }

                    public String toString() {
                        return DEFAULT.name();
                    }
                };
            }
        }
        ,
        UUID{

            @Override
            public JmsMessageIDBuilder createBuilder() {
                return new JmsMessageIDBuilder(){

                    @Override
                    public Object createMessageID(String producerId, long messageSequence) {
                        return java.util.UUID.randomUUID();
                    }

                    public String toString() {
                        return UUID.name();
                    }
                };
            }
        }
        ,
        UUID_STRING{

            @Override
            public JmsMessageIDBuilder createBuilder() {
                return new JmsMessageIDBuilder(){

                    @Override
                    public Object createMessageID(String producerId, long messageSequence) {
                        return java.util.UUID.randomUUID().toString();
                    }

                    public String toString() {
                        return UUID_STRING.name();
                    }
                };
            }
        }
        ,
        PREFIXED_UUID_STRING{

            @Override
            public JmsMessageIDBuilder createBuilder() {
                return new JmsMessageIDBuilder(){

                    @Override
                    public Object createMessageID(String producerId, long messageSequence) {
                        return "ID:" + java.util.UUID.randomUUID().toString();
                    }

                    public String toString() {
                        return PREFIXED_UUID_STRING.name();
                    }
                };
            }
        };


        public abstract JmsMessageIDBuilder createBuilder();

        public static JmsMessageIDBuilder create(String value) {
            return BUILTIN.valueOf(value.toUpperCase(Locale.ENGLISH)).createBuilder();
        }
    }
}

