/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.exceptions;

import javax.jms.JMSException;
import javax.jms.MessageEOFException;
import javax.jms.MessageFormatException;

public final class JmsExceptionSupport {
    private JmsExceptionSupport() {
    }

    public static JMSException create(String message, Throwable cause) {
        if (cause instanceof JMSException) {
            return (JMSException)cause;
        }
        if (cause.getCause() instanceof JMSException) {
            return (JMSException)cause.getCause();
        }
        if ((message == null || message.isEmpty()) && ((message = cause.getMessage()) == null || message.isEmpty())) {
            message = cause.toString();
        }
        JMSException exception = new JMSException(message);
        if (cause instanceof Exception) {
            exception.setLinkedException((Exception)cause);
        }
        exception.initCause(cause);
        return exception;
    }

    public static JMSException create(Throwable cause) {
        return JmsExceptionSupport.create(null, cause);
    }

    public static MessageEOFException createMessageEOFException(Throwable cause) {
        String message = cause.getMessage();
        if (message == null || message.length() == 0) {
            message = cause.toString();
        }
        MessageEOFException exception = new MessageEOFException(message);
        if (cause instanceof Exception) {
            exception.setLinkedException((Exception)cause);
        }
        exception.initCause(cause);
        return exception;
    }

    public static MessageFormatException createMessageFormatException(Throwable cause) {
        String message = cause.getMessage();
        if (message == null || message.length() == 0) {
            message = cause.toString();
        }
        MessageFormatException exception = new MessageFormatException(message);
        if (cause instanceof Exception) {
            exception.setLinkedException((Exception)cause);
        }
        exception.initCause(cause);
        return exception;
    }
}

