/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.message;

import java.util.Locale;
import java.util.UUID;

public interface JmsMessageIDBuilder {
    public Object createMessageID(String var1, long var2);

    public static enum BUILTIN {
        DEFAULT{

            @Override
            public JmsMessageIDBuilder createBuilder() {
                return new JmsMessageIDBuilder(){

                    @Override
                    public Object createMessageID(String producerId, long messageSequence) {
                        return producerId + "-" + messageSequence;
                    }

                    public String toString() {
                        return DEFAULT.name();
                    }
                };
            }
        }
        ,
        UUID{

            @Override
            public JmsMessageIDBuilder createBuilder() {
                return new JmsMessageIDBuilder(){

                    @Override
                    public Object createMessageID(String producerId, long messageSequence) {
                        return java.util.UUID.randomUUID();
                    }

                    public String toString() {
                        return UUID.name();
                    }
                };
            }
        }
        ,
        UUID_STRING{

            @Override
            public JmsMessageIDBuilder createBuilder() {
                return new JmsMessageIDBuilder(){

                    @Override
                    public Object createMessageID(String producerId, long messageSequence) {
                        return java.util.UUID.randomUUID().toString();
                    }

                    public String toString() {
                        return UUID_STRING.name();
                    }
                };
            }
        };


        public abstract JmsMessageIDBuilder createBuilder();

        public static JmsMessageIDBuilder create(String value) {
            return BUILTIN.valueOf(value.toUpperCase(Locale.ENGLISH)).createBuilder();
        }
    }
}

