/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.meta;

import org.apache.qpid.jms.meta.JmsConnectionInfo;
import org.apache.qpid.jms.meta.JmsResource;
import org.apache.qpid.jms.meta.JmsResourceVistor;
import org.apache.qpid.jms.meta.JmsSessionId;
import org.apache.qpid.jms.util.ToStringSupport;

public final class JmsSessionInfo
implements JmsResource,
Comparable<JmsSessionInfo> {
    private final JmsSessionId sessionId;
    private int acknowledgementMode;
    private boolean sendAcksAsync;

    public JmsSessionInfo(JmsConnectionInfo connectionInfo, long sessionId) {
        if (connectionInfo == null) {
            throw new IllegalArgumentException("Connection info object cannot be null");
        }
        this.sessionId = new JmsSessionId(connectionInfo.getId(), sessionId);
    }

    public JmsSessionInfo(JmsSessionId sessionId) {
        if (sessionId == null) {
            throw new IllegalArgumentException("session Id object cannot be null");
        }
        this.sessionId = sessionId;
    }

    public JmsSessionInfo copy() {
        JmsSessionInfo copy = new JmsSessionInfo(this.sessionId);
        this.copy(copy);
        return copy;
    }

    private void copy(JmsSessionInfo copy) {
        copy.acknowledgementMode = this.acknowledgementMode;
        copy.sendAcksAsync = this.sendAcksAsync;
    }

    @Override
    public JmsSessionId getId() {
        return this.sessionId;
    }

    @Override
    public void visit(JmsResourceVistor vistor) throws Exception {
        vistor.processSessionInfo(this);
    }

    public int getAcknowledgementMode() {
        return this.acknowledgementMode;
    }

    public void setAcknowledgementMode(int acknowledgementMode) {
        this.acknowledgementMode = acknowledgementMode;
    }

    public boolean isTransacted() {
        return this.acknowledgementMode == 0;
    }

    public boolean isSendAcksAsync() {
        return this.sendAcksAsync;
    }

    public void setSendAcksAsync(boolean sendAcksAsync) {
        this.sendAcksAsync = sendAcksAsync;
    }

    public String toString() {
        return ToStringSupport.toString(this);
    }

    public int hashCode() {
        return this.sessionId.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JmsSessionInfo other = (JmsSessionInfo)obj;
        return this.sessionId.equals(other.sessionId);
    }

    @Override
    public int compareTo(JmsSessionInfo other) {
        return this.sessionId.compareTo(other.sessionId);
    }
}

