/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.provider.amqp.message;

import java.util.HashSet;
import java.util.Set;
import org.apache.qpid.jms.JmsDestination;
import org.apache.qpid.jms.JmsQueue;
import org.apache.qpid.jms.JmsTemporaryQueue;
import org.apache.qpid.jms.JmsTemporaryTopic;
import org.apache.qpid.jms.JmsTopic;
import org.apache.qpid.jms.provider.amqp.AmqpConnection;
import org.apache.qpid.jms.provider.amqp.message.AmqpJmsMessageFacade;
import org.apache.qpid.proton.amqp.Symbol;

public class AmqpDestinationHelper {
    public static final AmqpDestinationHelper INSTANCE = new AmqpDestinationHelper();
    public static final String JMS_DEST_TYPE_MSG_ANNOTATION_SYMBOL_NAME = "x-opt-jms-dest";
    public static final String JMS_REPLY_TO_TYPE_MSG_ANNOTATION_SYMBOL_NAME = "x-opt-jms-reply-to";
    public static final byte QUEUE_TYPE = 0;
    public static final byte TOPIC_TYPE = 1;
    public static final byte TEMP_QUEUE_TYPE = 2;
    public static final byte TEMP_TOPIC_TYPE = 3;
    public static final Symbol QUEUE_CAPABILITY = Symbol.valueOf((String)"queue");
    public static final Symbol TOPIC_CAPABILITY = Symbol.valueOf((String)"topic");
    public static final Symbol TEMP_QUEUE_CAPABILITY = Symbol.valueOf((String)"temporary-queue");
    public static final Symbol TEMP_TOPIC_CAPABILITY = Symbol.valueOf((String)"temporary-topic");
    private static final byte UNKNOWN_TYPE = -1;

    public JmsDestination getJmsDestination(AmqpJmsMessageFacade message, JmsDestination consumerDestination) {
        String to = message.getToAddress();
        byte typeByte = this.getTypeByte(message, JMS_DEST_TYPE_MSG_ANNOTATION_SYMBOL_NAME);
        if (typeByte == -1) {
            typeByte = this.getTypeByte(message, "x-opt-to-type");
        }
        String name = this.stripPrefixIfNecessary(to, message.getConnection(), typeByte, consumerDestination);
        return this.createDestination(name, typeByte, consumerDestination, false);
    }

    public JmsDestination getJmsReplyTo(AmqpJmsMessageFacade message, JmsDestination consumerDestination) {
        String replyTo = message.getReplyToAddress();
        byte typeByte = this.getTypeByte(message, JMS_REPLY_TO_TYPE_MSG_ANNOTATION_SYMBOL_NAME);
        if (typeByte == -1) {
            typeByte = this.getTypeByte(message, "x-opt-reply-type");
        }
        String name = this.stripPrefixIfNecessary(replyTo, message.getConnection(), typeByte, consumerDestination);
        return this.createDestination(name, typeByte, consumerDestination, true);
    }

    private String stripPrefixIfNecessary(String address, AmqpConnection conn, byte typeByte, JmsDestination consumerDestination) {
        String topicPrefix;
        if (address == null) {
            return null;
        }
        if (typeByte == -1) {
            String queuePrefix = conn.getQueuePrefix();
            if (queuePrefix != null && address.startsWith(queuePrefix)) {
                return address.substring(queuePrefix.length());
            }
            String topicPrefix2 = conn.getTopicPrefix();
            if (topicPrefix2 != null && address.startsWith(topicPrefix2)) {
                return address.substring(topicPrefix2.length());
            }
        } else if (typeByte == 0) {
            String queuePrefix = conn.getQueuePrefix();
            if (queuePrefix != null && address.startsWith(queuePrefix)) {
                return address.substring(queuePrefix.length());
            }
        } else if (typeByte == 1 && (topicPrefix = conn.getTopicPrefix()) != null && address.startsWith(topicPrefix)) {
            return address.substring(topicPrefix.length());
        }
        return address;
    }

    private JmsDestination createDestination(String address, byte typeByte, JmsDestination consumerDestination, boolean useConsumerDestForTypeOnly) {
        if (address == null) {
            return useConsumerDestForTypeOnly ? null : consumerDestination;
        }
        if (typeByte != -1) {
            switch (typeByte) {
                case 0: {
                    return new JmsQueue(address);
                }
                case 1: {
                    return new JmsTopic(address);
                }
                case 2: {
                    return new JmsTemporaryQueue(address);
                }
                case 3: {
                    return new JmsTemporaryTopic(address);
                }
            }
        }
        if (consumerDestination.isQueue()) {
            if (consumerDestination.isTemporary()) {
                return new JmsTemporaryQueue(address);
            }
            return new JmsQueue(address);
        }
        if (consumerDestination.isTopic()) {
            if (consumerDestination.isTemporary()) {
                return new JmsTemporaryTopic(address);
            }
            return new JmsTopic(address);
        }
        return new JmsQueue(address);
    }

    public void setToAddressFromDestination(AmqpJmsMessageFacade message, JmsDestination destination) {
        String address = this.getDestinationAddress(destination, message.getConnection());
        byte typeValue = this.toTypeAnnotation(destination);
        message.setToAddress(address);
        if (address == null || typeValue == -1) {
            message.removeMessageAnnotation(JMS_DEST_TYPE_MSG_ANNOTATION_SYMBOL_NAME);
        } else {
            message.setMessageAnnotation(JMS_DEST_TYPE_MSG_ANNOTATION_SYMBOL_NAME, typeValue);
        }
        message.removeMessageAnnotation("x-opt-to-type");
    }

    public void setReplyToAddressFromDestination(AmqpJmsMessageFacade message, JmsDestination destination) {
        String replyToAddress = this.getDestinationAddress(destination, message.getConnection());
        byte typeValue = this.toTypeAnnotation(destination);
        message.setReplyToAddress(replyToAddress);
        if (replyToAddress == null || typeValue == -1) {
            message.removeMessageAnnotation(JMS_REPLY_TO_TYPE_MSG_ANNOTATION_SYMBOL_NAME);
        } else {
            message.setMessageAnnotation(JMS_REPLY_TO_TYPE_MSG_ANNOTATION_SYMBOL_NAME, typeValue);
        }
        message.removeMessageAnnotation("x-opt-reply-type");
    }

    public String getDestinationAddress(JmsDestination destination, AmqpConnection conn) {
        if (destination == null) {
            return null;
        }
        String name = destination.getName();
        if (!destination.isTemporary()) {
            String topicPrefix;
            String queuePrefix;
            if (destination.isQueue() && (queuePrefix = conn.getQueuePrefix()) != null && !name.startsWith(queuePrefix)) {
                return queuePrefix + name;
            }
            if (destination.isTopic() && (topicPrefix = conn.getTopicPrefix()) != null && !name.startsWith(topicPrefix)) {
                return topicPrefix + name;
            }
        }
        return name;
    }

    private byte toTypeAnnotation(JmsDestination destination) {
        if (destination == null) {
            return -1;
        }
        if (destination.isQueue()) {
            if (destination.isTemporary()) {
                return 2;
            }
            return 0;
        }
        if (destination.isTopic()) {
            if (destination.isTemporary()) {
                return 3;
            }
            return 1;
        }
        return -1;
    }

    Set<String> splitAttributesString(String typeString) {
        if (typeString == null) {
            return null;
        }
        HashSet<String> typeSet = new HashSet<String>();
        for (String attr : typeString.split("\\s*,\\s*")) {
            if (attr.equals("")) continue;
            typeSet.add(attr);
        }
        return typeSet;
    }

    private byte getTypeByte(AmqpJmsMessageFacade message, String annotationName) {
        Object typeAnnotation = message.getMessageAnnotation(annotationName);
        if (typeAnnotation == null) {
            return -1;
        }
        if (typeAnnotation instanceof Byte) {
            return (Byte)typeAnnotation;
        }
        String typeString = String.valueOf(typeAnnotation);
        Set<String> typeSet = null;
        if (typeString != null) {
            typeSet = this.splitAttributesString(typeString);
        }
        if (typeSet != null && !typeSet.isEmpty()) {
            if (typeSet.contains("queue")) {
                if (typeSet.contains("temporary")) {
                    return 2;
                }
                return 0;
            }
            if (typeSet.contains("topic")) {
                if (typeSet.contains("temporary")) {
                    return 3;
                }
                return 1;
            }
        }
        return -1;
    }

    public Symbol toTypeCapability(JmsDestination destination) {
        if (destination == null) {
            return null;
        }
        if (destination.isQueue()) {
            if (destination.isTemporary()) {
                return TEMP_QUEUE_CAPABILITY;
            }
            return QUEUE_CAPABILITY;
        }
        if (destination.isTopic()) {
            if (destination.isTemporary()) {
                return TEMP_TOPIC_CAPABILITY;
            }
            return TOPIC_CAPABILITY;
        }
        return null;
    }
}

