/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.provider.amqp.message;

import java.io.IOException;
import java.io.Serializable;
import javax.jms.JMSException;
import org.apache.qpid.jms.exceptions.JmsExceptionSupport;
import org.apache.qpid.jms.message.JmsBytesMessage;
import org.apache.qpid.jms.message.JmsMapMessage;
import org.apache.qpid.jms.message.JmsMessage;
import org.apache.qpid.jms.message.JmsMessageFactory;
import org.apache.qpid.jms.message.JmsObjectMessage;
import org.apache.qpid.jms.message.JmsStreamMessage;
import org.apache.qpid.jms.message.JmsTextMessage;
import org.apache.qpid.jms.provider.amqp.AmqpConnection;
import org.apache.qpid.jms.provider.amqp.message.AmqpJmsBytesMessageFacade;
import org.apache.qpid.jms.provider.amqp.message.AmqpJmsMapMessageFacade;
import org.apache.qpid.jms.provider.amqp.message.AmqpJmsMessageFacade;
import org.apache.qpid.jms.provider.amqp.message.AmqpJmsObjectMessageFacade;
import org.apache.qpid.jms.provider.amqp.message.AmqpJmsStreamMessageFacade;
import org.apache.qpid.jms.provider.amqp.message.AmqpJmsTextMessageFacade;

public class AmqpJmsMessageFactory
implements JmsMessageFactory {
    private final AmqpConnection connection;

    public AmqpJmsMessageFactory(AmqpConnection connection) {
        this.connection = connection;
    }

    public AmqpConnection getAmqpConnection() {
        return this.connection;
    }

    @Override
    public JmsMessage createMessage() throws JMSException {
        return new JmsMessage(new AmqpJmsMessageFacade(this.connection));
    }

    @Override
    public JmsTextMessage createTextMessage() throws JMSException {
        return this.createTextMessage(null);
    }

    @Override
    public JmsTextMessage createTextMessage(String payload) throws JMSException {
        AmqpJmsTextMessageFacade facade = new AmqpJmsTextMessageFacade(this.connection);
        if (payload != null) {
            facade.setText(payload);
        }
        return new JmsTextMessage(facade);
    }

    @Override
    public JmsBytesMessage createBytesMessage() throws JMSException {
        return new JmsBytesMessage(new AmqpJmsBytesMessageFacade(this.connection));
    }

    @Override
    public JmsMapMessage createMapMessage() throws JMSException {
        return new JmsMapMessage(new AmqpJmsMapMessageFacade(this.connection));
    }

    @Override
    public JmsStreamMessage createStreamMessage() throws JMSException {
        return new JmsStreamMessage(new AmqpJmsStreamMessageFacade(this.connection));
    }

    @Override
    public JmsObjectMessage createObjectMessage() throws JMSException {
        return this.createObjectMessage(null);
    }

    @Override
    public JmsObjectMessage createObjectMessage(Serializable payload) throws JMSException {
        AmqpJmsObjectMessageFacade facade = new AmqpJmsObjectMessageFacade(this.connection, this.connection.isObjectMessageUsesAmqpTypes());
        if (payload != null) {
            try {
                facade.setObject(payload);
            }
            catch (IOException e) {
                throw JmsExceptionSupport.create(e);
            }
        }
        return new JmsObjectMessage(facade);
    }
}

