/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.provider.amqp;

import java.io.IOException;
import org.apache.qpid.jms.meta.JmsConnectionInfo;
import org.apache.qpid.jms.meta.JmsResource;
import org.apache.qpid.jms.provider.AsyncResult;
import org.apache.qpid.jms.provider.amqp.AmqpProvider;
import org.apache.qpid.jms.provider.amqp.AmqpResource;
import org.apache.qpid.jms.provider.amqp.AmqpResourceParent;
import org.apache.qpid.jms.provider.amqp.AmqpSupport;
import org.apache.qpid.proton.engine.Endpoint;
import org.apache.qpid.proton.engine.EndpointState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AmqpAbstractResource<R extends JmsResource, E extends Endpoint>
implements AmqpResource {
    private static final Logger LOG = LoggerFactory.getLogger(AmqpAbstractResource.class);
    protected AsyncResult closeRequest;
    private final E endpoint;
    private final R resourceInfo;
    private final AmqpResourceParent parent;

    public AmqpAbstractResource(R resourceInfo, E endpoint) {
        this(resourceInfo, endpoint, null);
    }

    public AmqpAbstractResource(R resourceInfo, E endpoint, AmqpResourceParent parent) {
        this.parent = parent;
        this.endpoint = endpoint;
        this.resourceInfo = resourceInfo;
        this.resourceInfo.getId().setProviderHint(this);
    }

    public void close(AsyncResult request) {
        if (this.parent != null) {
            this.parent.removeChildResource(this);
        }
        if (this.getEndpoint().getLocalState() == EndpointState.CLOSED || this.getEndpoint().getRemoteState() == EndpointState.CLOSED) {
            if (this.getEndpoint().getLocalState() != EndpointState.CLOSED) {
                this.getEndpoint().close();
                this.getEndpoint().free();
                this.getEndpoint().setContext(null);
            }
            request.onSuccess();
            return;
        }
        this.closeRequest = request;
        this.closeOrDetachEndpoint();
    }

    public void resourceClosed() {
        this.getEndpoint().close();
        this.getEndpoint().free();
        this.getEndpoint().setContext(null);
        if (this.closeRequest != null) {
            this.closeRequest.onSuccess();
            this.closeRequest = null;
        }
    }

    public void remotelyClosed(AmqpProvider provider) {
        Exception error = AmqpSupport.convertToException(this.getEndpoint().getRemoteCondition());
        if (this.parent != null) {
            this.parent.removeChildResource(this);
        }
        if (this.endpoint != null) {
            this.endpoint.close();
        }
        LOG.info("Resource {} was remotely closed", this.getResourceInfo());
        if (this.getResourceInfo() instanceof JmsConnectionInfo) {
            provider.fireProviderException(error);
        } else {
            provider.fireResourceRemotelyClosed((JmsResource)this.getResourceInfo(), error);
        }
    }

    protected void closeOrDetachEndpoint() {
        this.getEndpoint().close();
    }

    public E getEndpoint() {
        return this.endpoint;
    }

    public R getResourceInfo() {
        return this.resourceInfo;
    }

    public AmqpResourceParent getParent() {
        return this.parent;
    }

    public boolean isOpen() {
        return this.getEndpoint().getRemoteState() == EndpointState.ACTIVE;
    }

    public boolean isClosed() {
        return this.getEndpoint().getLocalState() == EndpointState.CLOSED;
    }

    public boolean isAwaitingClose() {
        return this.closeRequest != null;
    }

    public EndpointState getLocalState() {
        if (this.getEndpoint() == null) {
            return EndpointState.UNINITIALIZED;
        }
        return this.getEndpoint().getLocalState();
    }

    public EndpointState getRemoteState() {
        if (this.getEndpoint() == null) {
            return EndpointState.UNINITIALIZED;
        }
        return this.getEndpoint().getRemoteState();
    }

    @Override
    public final void processRemoteOpen(AmqpProvider provider) throws IOException {
    }

    @Override
    public void processRemoteDetach(AmqpProvider provider) throws IOException {
        if (this.isAwaitingClose()) {
            LOG.debug("{} is now closed: ", (Object)this);
            this.resourceClosed();
        } else {
            this.remotelyClosed(provider);
        }
    }

    @Override
    public void processRemoteClose(AmqpProvider provider) throws IOException {
        if (this.isAwaitingClose()) {
            LOG.debug("{} is now closed: ", (Object)this);
            this.resourceClosed();
        } else {
            this.remotelyClosed(provider);
        }
    }

    @Override
    public void processDeliveryUpdates(AmqpProvider provider) throws IOException {
    }

    @Override
    public void processFlowUpdates(AmqpProvider provider) throws IOException {
    }
}

