/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.transports;

import java.net.Socket;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedKeyManager;

public class X509AliasKeyManager
extends X509ExtendedKeyManager {
    private X509ExtendedKeyManager delegate;
    private String alias;

    public X509AliasKeyManager(String alias, X509ExtendedKeyManager delegate) throws IllegalArgumentException {
        if (alias == null) {
            throw new IllegalArgumentException("The given key alias must not be null.");
        }
        this.alias = alias;
        this.delegate = delegate;
    }

    @Override
    public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
        return this.alias;
    }

    @Override
    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        return this.alias;
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        return this.delegate.getCertificateChain(alias);
    }

    @Override
    public String[] getClientAliases(String keyType, Principal[] issuers) {
        return new String[]{this.alias};
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        return this.delegate.getPrivateKey(alias);
    }

    @Override
    public String[] getServerAliases(String keyType, Principal[] issuers) {
        return new String[]{this.alias};
    }

    @Override
    public String chooseEngineClientAlias(String[] keyType, Principal[] issuers, SSLEngine engine) {
        return this.alias;
    }

    @Override
    public String chooseEngineServerAlias(String keyType, Principal[] issuers, SSLEngine engine) {
        return this.alias;
    }
}

