/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.qmf2.tools;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.jms.Connection;
import org.apache.qpid.qmf2.common.ObjectId;
import org.apache.qpid.qmf2.common.QmfCallback;
import org.apache.qpid.qmf2.common.QmfEvent;
import org.apache.qpid.qmf2.common.QmfEventListener;
import org.apache.qpid.qmf2.common.QmfException;
import org.apache.qpid.qmf2.common.WorkItem;
import org.apache.qpid.qmf2.console.Agent;
import org.apache.qpid.qmf2.console.AgentHeartbeatWorkItem;
import org.apache.qpid.qmf2.console.AgentRestartedWorkItem;
import org.apache.qpid.qmf2.console.Console;
import org.apache.qpid.qmf2.console.EventReceivedWorkItem;
import org.apache.qpid.qmf2.console.QmfConsoleData;
import org.apache.qpid.qmf2.util.ConnectionHelper;
import org.apache.qpid.qmf2.util.GetOpt;

public final class ConnectionLogger
implements QmfEventListener {
    private static final String _usage = "Usage: ConnectionLogger [options]\n";
    private static final String _options = "Options:\n  -h, --help            show this help message and exit\n  -q                    log queue and binding information for consumer connections\n  -a <address>, --broker-address=<address>\n                        broker-addr is in the form:  [username/password@]\n                        hostname | ip-address [:<port>]   ex:  localhost,\n                        10.1.1.7:10000, broker-host:10000,\n                        guest/guest@localhost\n  --sasl-mechanism=<mech>\n                        SASL mechanism for authentication (e.g. EXTERNAL,\n                        ANONYMOUS, PLAIN, CRAM-MD5, DIGEST-MD5, GSSAPI). SASL\n                        automatically picks the most secure available\n                        mechanism - use this option to override.\n";
    private Console _console;
    private boolean _logQueues;
    private boolean _stateChanged = false;

    public ConnectionLogger(String url, String connectionOptions, boolean logQueues) {
        try {
            Connection connection = ConnectionHelper.createConnection((String)url, (String)connectionOptions);
            this._console = new Console((QmfCallback)this);
            this._console.addConnection(connection);
            this._logQueues = logQueues;
            System.out.println("Hit Return to exit");
            this.logConnectionInformation();
        }
        catch (QmfException qmfe) {
            System.err.println("QmfException " + qmfe.getMessage() + " caught in ConnectionLogger constructor");
        }
    }

    private QmfConsoleData findById(List<QmfConsoleData> items, ObjectId id) {
        for (QmfConsoleData item : items) {
            if (!item.getObjectId().equals((Object)id)) continue;
            return item;
        }
        return null;
    }

    private void logQueueInformation(ObjectId ref) {
        List queues = this._console.getObjects("org.apache.qpid.broker", "queue");
        List bindings = this._console.getObjects("org.apache.qpid.broker", "binding");
        List exchanges = this._console.getObjects("org.apache.qpid.broker", "exchange");
        for (QmfConsoleData queue : queues) {
            ObjectId queueId = queue.getObjectId();
            if (ref != null && !ref.equals((Object)queueId)) continue;
            System.out.printf("    Queue '%s'\n", queue.getStringValue("name"));
            System.out.println("        arguments " + (Map)queue.getValue("arguments"));
            for (QmfConsoleData binding : bindings) {
                ObjectId queueRef = binding.getRefValue("queueRef");
                if (!queueRef.equals((Object)queueId)) continue;
                ObjectId exchangeRef = binding.getRefValue("exchangeRef");
                QmfConsoleData exchange = this.findById(exchanges, exchangeRef);
                String exchangeName = "<unknown>";
                if (exchange != null && (exchangeName = exchange.getStringValue("name")).equals("")) {
                    exchangeName = "''";
                }
                String bindingKey = binding.getStringValue("bindingKey");
                Map arguments = (Map)binding.getValue("arguments");
                if (arguments.isEmpty()) {
                    System.out.printf("        bind [%s] => %s\n", bindingKey, exchangeName);
                    continue;
                }
                System.out.printf("        bind [%s] => %s %s\n", bindingKey, exchangeName, arguments);
            }
        }
    }

    private void logConnectionInformation() {
        System.out.println("\n\n**** ConnectionLogger: Logging current connection information ****");
        List connections = this._console.getObjects("org.apache.qpid.broker", "connection");
        List sessions = this._console.getObjects("org.apache.qpid.broker", "session");
        List subscriptions = this._console.getObjects("org.apache.qpid.broker", "subscription");
        for (QmfConsoleData connection : connections) {
            String[] properties;
            System.out.printf("\nConnection '%s'\n", connection.getStringValue("address"));
            for (String p : properties = new String[]{"authIdentity", "remoteProcessName", "federationLink"}) {
                System.out.println(p + ": " + connection.getStringValue(p));
            }
            System.out.println("createTimestamp: " + new Date(connection.getCreateTime() / 1000000L));
            ObjectId connectionId = connection.getObjectId();
            for (QmfConsoleData session : sessions) {
                ObjectId connectionRef = session.getRefValue("connectionRef");
                if (!connectionRef.equals((Object)connectionId)) continue;
                System.out.printf("Session '%s'\n", session.getStringValue("name"));
                int subscriptionCount = 0;
                ObjectId sessionId = session.getObjectId();
                for (QmfConsoleData subscription : subscriptions) {
                    ObjectId sessionRef = subscription.getRefValue("sessionRef");
                    if (!sessionRef.equals((Object)sessionId)) continue;
                    ++subscriptionCount;
                    ObjectId queueRef = subscription.getRefValue("queueRef");
                    if (!this._logQueues) continue;
                    this.logQueueInformation(queueRef);
                }
                if (subscriptionCount != 0) continue;
                System.out.println("    ** No Subscriptions for this Session - probably a producer only Session **");
            }
        }
    }

    public void onEvent(WorkItem wi) {
        if (wi instanceof EventReceivedWorkItem) {
            EventReceivedWorkItem item = (EventReceivedWorkItem)wi;
            Agent agent = item.getAgent();
            QmfEvent event = item.getEvent();
            String className = event.getSchemaClassId().getClassName();
            if (className.equals("clientConnect") || className.equals("clientDisconnect")) {
                this._stateChanged = true;
            }
        } else if (wi instanceof AgentRestartedWorkItem) {
            this._stateChanged = true;
        } else if (wi instanceof AgentHeartbeatWorkItem) {
            AgentHeartbeatWorkItem item = (AgentHeartbeatWorkItem)wi;
            Agent agent = item.getAgent();
            if (this._stateChanged && agent.getName().contains("qpidd")) {
                this.logConnectionInformation();
                this._stateChanged = false;
            }
        }
    }

    public static void main(String[] args) {
        String logLevel = System.getProperty("amqj.logging.level");
        logLevel = logLevel == null ? "FATAL" : logLevel;
        System.setProperty("amqj.logging.level", logLevel);
        String[] longOpts = new String[]{"help", "broker-address=", "sasl-mechanism="};
        try {
            String host = "localhost";
            String connectionOptions = "{reconnect: true}";
            boolean logQueues = false;
            GetOpt getopt = new GetOpt(args, "ha:q", longOpts);
            List optList = getopt.getOptList();
            String[] cargs = new String[]{};
            cargs = getopt.getEncArgs().toArray(cargs);
            for (String[] opt : optList) {
                if (opt[0].equals("-h") || opt[0].equals("--help")) {
                    System.out.println(_usage);
                    System.out.println(_options);
                    System.exit(1);
                    continue;
                }
                if (opt[0].equals("-a") || opt[0].equals("--broker-address")) {
                    host = opt[1];
                    continue;
                }
                if (opt[0].equals("-q")) {
                    logQueues = true;
                    continue;
                }
                if (!opt[0].equals("--sasl-mechanism")) continue;
                connectionOptions = "{reconnect: true, sasl_mechs: " + opt[1] + "}";
            }
            ConnectionLogger logger = new ConnectionLogger(host, connectionOptions, logQueues);
        }
        catch (IllegalArgumentException e) {
            System.out.println(_usage);
            System.out.println(e.getMessage());
            System.exit(1);
        }
        BufferedReader commandLine = new BufferedReader(new InputStreamReader(System.in));
        try {
            String s = commandLine.readLine();
            System.exit(0);
        }
        catch (IOException e) {
            System.out.println("ConnectionLogger main(): IOException: " + e.getMessage());
        }
    }
}

