/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.qmf2.tools;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import javax.jms.Connection;
import org.apache.qpid.qmf2.common.QmfCallback;
import org.apache.qpid.qmf2.common.QmfEvent;
import org.apache.qpid.qmf2.common.QmfEventListener;
import org.apache.qpid.qmf2.common.QmfException;
import org.apache.qpid.qmf2.common.WorkItem;
import org.apache.qpid.qmf2.console.Console;
import org.apache.qpid.qmf2.console.EventReceivedWorkItem;
import org.apache.qpid.qmf2.util.ConnectionHelper;
import org.apache.qpid.qmf2.util.GetOpt;

public final class QpidPrintEvents
implements QmfEventListener {
    private static final String _usage = "Usage: QpidPrintEvents [options] [broker-addr]...\n";
    private static final String _description = "Collect and print events from one or more Qpid message brokers.\n\nIf no broker-addr is supplied, QpidPrintEvents connects to 'localhost:5672'.\n\n[broker-addr] syntax:\n\n[username/password@] hostname\nip-address [:<port>]\n\nExamples:\n\n$ QpidPrintEvents localhost:5672\n$ QpidPrintEvents 10.1.1.7:10000\n$ QpidPrintEvents guest/guest@broker-host:10000\n";
    private static final String _options = "Options:\n  -h, --help            show this help message and exit\n  --heartbeats          Use heartbeats.\n  --sasl-mechanism=<mech>\n                        SASL mechanism for authentication (e.g. EXTERNAL,\n                        ANONYMOUS, PLAIN, CRAM-MD5, DIGEST-MD5, GSSAPI). SASL\n                        automatically picks the most secure available\n                        mechanism - use this option to override.\n";
    private final String _url;
    private Console _console;

    public QpidPrintEvents(String url, String connectionOptions) {
        System.out.println("Connecting to " + url);
        this._url = url;
        try {
            Connection connection = ConnectionHelper.createConnection((String)url, (String)connectionOptions);
            this._console = new Console((QmfCallback)this);
            this._console.addConnection(connection);
        }
        catch (QmfException qmfe) {
            System.err.println("QmfException " + qmfe.getMessage() + " caught in QpidPrintEvents constructor");
        }
    }

    public void onEvent(WorkItem wi) {
        if (wi instanceof EventReceivedWorkItem) {
            EventReceivedWorkItem item = (EventReceivedWorkItem)wi;
            QmfEvent event = item.getEvent();
            System.out.println(event + " broker=" + this._url);
        }
    }

    public static void main(String[] args) {
        String logLevel = System.getProperty("amqj.logging.level");
        logLevel = logLevel == null ? "FATAL" : logLevel;
        System.setProperty("amqj.logging.level", logLevel);
        String[] longOpts = new String[]{"help", "heartbeats", "sasl-mechanism="};
        try {
            String connectionOptions = "{reconnect: true}";
            GetOpt getopt = new GetOpt(args, "h", longOpts);
            List optList = getopt.getOptList();
            String[] cargs = new String[]{};
            cargs = getopt.getEncArgs().toArray(cargs);
            for (String[] opt : optList) {
                if (opt[0].equals("-h") || opt[0].equals("--help")) {
                    System.out.println(_usage);
                    System.out.println(_description);
                    System.out.println(_options);
                    System.exit(1);
                    continue;
                }
                if (opt[0].equals("--heartbeats") || !opt[0].equals("--sasl-mechanism")) continue;
                connectionOptions = "{reconnect: true, sasl_mechs: " + opt[1] + "}";
            }
            int nargs = cargs.length;
            if (nargs == 0) {
                cargs = new String[]{"localhost"};
            }
            for (String url : cargs) {
                QpidPrintEvents eventPrinter = new QpidPrintEvents(url, connectionOptions);
            }
        }
        catch (IllegalArgumentException e) {
            System.out.println(_usage);
            System.exit(1);
        }
        BufferedReader commandLine = new BufferedReader(new InputStreamReader(System.in));
        try {
            System.out.println("Hit Return to exit");
            String s = commandLine.readLine();
            System.exit(0);
        }
        catch (IOException e) {
            System.out.println("QpidPrintEvents main(): IOException: " + e.getMessage());
        }
    }
}

